/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.graphics.Color;

public abstract class BaseMTJScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;

    public static TextAttribute createTextAttribute(IColorManager iColorManager, String string) {
        Color color = iColorManager.getColor(string);
        int n = 0;
        IPreferenceStore iPreferenceStore = MTJUIPlugin.getDefault().getPreferenceStore();
        if (iPreferenceStore.getBoolean(String.valueOf(string) + "_bold")) {
            n |= 1;
        }
        if (iPreferenceStore.getBoolean(String.valueOf(string) + "_italic")) {
            n |= 2;
        }
        return new TextAttribute(color, null, n);
    }

    public BaseMTJScanner(IColorManager iColorManager) {
        this.fColorManager = iColorManager;
        this.initialize();
    }

    protected BaseMTJScanner() {
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (this.affectsTextPresentation(string)) {
            Token token = this.getTokenAffected(propertyChangeEvent);
            if (string.endsWith("_bold")) {
                this.adaptToStyleChange(propertyChangeEvent, token, 1);
            } else if (string.endsWith("_italic")) {
                this.adaptToStyleChange(propertyChangeEvent, token, 2);
            } else {
                this.adaptToColorChange(propertyChangeEvent, token);
            }
        }
    }

    public abstract boolean affectsTextPresentation(String var1);

    public void setColorManager(IColorManager iColorManager) {
        this.fColorManager = iColorManager;
    }

    protected void adaptToColorChange(PropertyChangeEvent propertyChangeEvent, Token token) {
        TextAttribute textAttribute = (TextAttribute)token.getData();
        token.setData((Object)new TextAttribute(this.fColorManager.getColor(propertyChangeEvent.getProperty()), textAttribute.getBackground(), textAttribute.getStyle()));
    }

    protected void adaptToStyleChange(PropertyChangeEvent propertyChangeEvent, Token token, int n) {
        TextAttribute textAttribute;
        boolean bl;
        if (token == null) {
            return;
        }
        boolean bl2 = false;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        boolean bl3 = bl = ((textAttribute = (TextAttribute)token.getData()).getStyle() & n) == n;
        if (bl != bl2) {
            Color color = textAttribute.getForeground();
            Color color2 = textAttribute.getBackground();
            int n2 = bl2 ? textAttribute.getStyle() | n : textAttribute.getStyle() & ~n;
            token.setData((Object)new TextAttribute(color, color2, n2));
        }
    }

    protected TextAttribute createTextAttribute(String string) {
        return BaseMTJScanner.createTextAttribute(this.fColorManager, string);
    }

    protected abstract Token getTokenAffected(PropertyChangeEvent var1);

    protected abstract void initialize();
}

