/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;

public class CollapseAction
extends Action {
    private int fExpandToLevel;
    private Object fTreeObject;
    private AbstractTreeViewer fTreeViewer;

    public CollapseAction(AbstractTreeViewer abstractTreeViewer, String string) {
        super(string, 1);
        this.fExpandToLevel = 0;
        this.fTreeObject = null;
        this.initialize(abstractTreeViewer, string);
    }

    public CollapseAction(AbstractTreeViewer abstractTreeViewer, String string, int n, Object object) {
        super(string, 1);
        this.fExpandToLevel = n;
        this.fTreeObject = object;
        this.initialize(abstractTreeViewer, string);
    }

    public void run() {
        if (this.fTreeViewer == null) {
            return;
        }
        if (this.fTreeObject != null && this.fExpandToLevel > 0) {
            this.fTreeViewer.getControl().setRedraw(false);
            this.fTreeViewer.collapseAll();
            this.fTreeViewer.expandToLevel(this.fTreeObject, 1);
            this.fTreeViewer.getControl().setRedraw(true);
        } else {
            this.fTreeViewer.collapseAll();
        }
    }

    private void initialize(AbstractTreeViewer abstractTreeViewer, String string) {
        this.setToolTipText(string);
        this.setImageDescriptor(MTJUIPluginImages.DESC_COLLAPSE_ALL);
        this.fTreeViewer = abstractTreeViewer;
    }
}

