/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.core.service.MarketplaceService;
import org.eclipse.epp.internal.mpc.core.service.News;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.core.service.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMarketplaceService
implements MarketplaceService {
    private final MarketplaceService delegate;
    private int maxCacheSize = 30;
    private final Map<String, Reference<Object>> cache = new LinkedHashMap<String, Reference<Object>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Reference<Object>> eldest) {
            return this.size() > CachingMarketplaceService.this.maxCacheSize || eldest.getValue().get() == null;
        }
    };

    public CachingMarketplaceService(MarketplaceService delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    @Override
    public List<Market> listMarkets(IProgressMonitor monitor) throws CoreException {
        return this.delegate.listMarkets(monitor);
    }

    @Override
    public Market getMarket(Market market, IProgressMonitor monitor) throws CoreException {
        return this.delegate.getMarket(market, monitor);
    }

    @Override
    public Category getCategory(Category category, IProgressMonitor monitor) throws CoreException {
        return this.delegate.getCategory(category, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(Node node, IProgressMonitor monitor) throws CoreException {
        Map<String, Reference<Object>> map;
        String nodeKey = this.computeNodeKey(node);
        Node nodeResult = null;
        if (nodeKey != null) {
            map = this.cache;
            synchronized (map) {
                Reference<Object> reference = this.cache.get(nodeKey);
                if (reference != null) {
                    nodeResult = (Node)reference.get();
                }
            }
        }
        if (nodeResult == null && (nodeResult = this.delegate.getNode(node, monitor)) != null) {
            map = this.cache;
            synchronized (map) {
                this.cache.put(this.computeNodeKey(nodeResult), new SoftReference<Node>(nodeResult));
            }
        }
        return nodeResult;
    }

    private String computeNodeKey(Node node) {
        if (node.getId() != null) {
            return "Node:" + node.getId();
        }
        return null;
    }

    @Override
    public SearchResult search(final Market market, final Category category, final String queryText, IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("search", market, category, queryText);
        return this.performSearch(monitor, key, new SearchOperation(){

            public SearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.search(market, category, queryText, monitor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult performSearch(IProgressMonitor monitor, String key, SearchOperation searchOperation) throws CoreException {
        SearchResult result = null;
        Map<String, Reference<Object>> map = this.cache;
        synchronized (map) {
            Reference<Object> reference = this.cache.get(key);
            if (reference != null) {
                result = (SearchResult)reference.get();
            }
        }
        if (result == null && (result = searchOperation.doSearch(monitor)) != null) {
            map = this.cache;
            synchronized (map) {
                this.cache.put(key, new SoftReference<SearchResult>(result));
            }
        }
        return result;
    }

    private String computeSearchKey(String prefix, Market market, Category category, String queryText) {
        return String.valueOf(prefix) + ":" + (market == null ? "" : market.getId()) + ":" + (category == null ? "" : category.getId()) + ":" + (queryText == null ? "" : queryText.trim());
    }

    @Override
    public SearchResult featured(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("featured", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public SearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.featured(monitor);
            }
        });
    }

    @Override
    public SearchResult featured(IProgressMonitor monitor, final Market market, final Category category) throws CoreException {
        String key = this.computeSearchKey("featured", market, category, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public SearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.featured(monitor, market, category);
            }
        });
    }

    @Override
    public SearchResult recent(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("recent", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public SearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.recent(monitor);
            }
        });
    }

    @Override
    public SearchResult favorites(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("favorites", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public SearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.favorites(monitor);
            }
        });
    }

    @Override
    public SearchResult popular(IProgressMonitor monitor) throws CoreException {
        String key = this.computeSearchKey("popular", null, null, null);
        return this.performSearch(monitor, key, new SearchOperation(){

            public SearchResult doSearch(IProgressMonitor monitor) throws CoreException {
                return CachingMarketplaceService.this.delegate.popular(monitor);
            }
        });
    }

    @Override
    public News news(IProgressMonitor monitor) throws CoreException {
        return this.delegate.news(monitor);
    }

    @Override
    public void reportInstallError(IProgressMonitor monitor, IStatus result, Set<Node> nodes, Set<String> iuIdsAndVersions, String resolutionDetails) throws CoreException {
        this.delegate.reportInstallError(monitor, result, nodes, iuIdsAndVersions, resolutionDetails);
    }

    private static interface SearchOperation {
        public SearchResult doSearch(IProgressMonitor var1) throws CoreException;
    }
}

