/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.uml2.diagram.common.links.PortOperationsExt;
import org.eclipse.uml2.diagram.common.links.ProvidedInterfaceLink;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class ProvidedPortLinkHelper {
    private final EObject mySource;
    private final EObject myTarget;

    public ProvidedPortLinkHelper(AdapterFactoryEditingDomain editingDomain, EObject source, EObject target) {
        this.mySource = source;
        this.myTarget = target;
    }

    public void create() {
        Port port = this.getSource();
        Interface targetInterface = this.getTarget();
        if (port == null || targetInterface == null) {
            return;
        }
        Type portType = port.getType();
        if (portType == null) {
            port.setType((Type)targetInterface);
            return;
        }
        if (portType instanceof Classifier) {
            this.createRealization(port, targetInterface, (Classifier)portType);
        }
    }

    public boolean canCreate() {
        return true;
    }

    public void reorientSource(Port newSource) {
        Type portType;
        ProvidedInterfaceLink realization;
        if (this.getTarget().equals(this.getSource().getType())) {
            this.getSource().setType(null);
            realization = null;
        } else {
            realization = PortOperationsExt.getProvideds(this.getSource(), this.getTarget());
            realization.getRealization().getClients().remove((Object)realization.getSource());
            portType = newSource.getType();
            if (portType == null) {
                realization.getRealization().getSuppliers().remove((Object)this.getTarget());
                if (realization.getRealization().getSuppliers().isEmpty() && realization.getRealization().getClients().isEmpty()) {
                    realization.getRealization().destroy();
                }
            }
        }
        portType = newSource.getType();
        if (portType == null) {
            newSource.setType((Type)this.getTarget());
            return;
        }
        if (portType instanceof Classifier) {
            if (realization == null) {
                this.createRealization(newSource, this.getTarget(), (Classifier)portType);
            } else {
                realization.getRealization().getClients().add((Object)((Classifier)portType));
            }
        }
    }

    public boolean canReorientSource(Port newSource) {
        return true;
    }

    public void reorientTarget(Interface newTarget) {
        Port port = this.getSource();
        Classifier portType = (Classifier)port.getType();
        if (this.getTarget().equals(portType)) {
            port.setType((Type)newTarget);
            return;
        }
        InterfaceRealization dependency = PortOperationsExt.getProvideds(port, this.getTarget()).getRealization();
        dependency.getSuppliers().remove((Object)this.getTarget());
        dependency.getSuppliers().add((Object)newTarget);
    }

    public boolean canReorientTarget(Interface newTarget) {
        return true;
    }

    private Realization createRealization(Port port, Interface targetInterface, Classifier portType) {
        Package realizationContainer = null;
        Port element = this.getSource();
        while (element != null) {
            if (element instanceof Package) {
                realizationContainer = (Package)element;
                break;
            }
            element = element.eContainer();
        }
        if (realizationContainer == null) {
            return null;
        }
        InterfaceRealization realization = UMLFactory.eINSTANCE.createInterfaceRealization();
        realizationContainer.getPackagedElements().add((Object)realization);
        realization.getClients().add((Object)portType);
        realization.getSuppliers().add((Object)targetInterface);
        return realization;
    }

    private Port getSource() {
        return (Port)this.mySource;
    }

    private Interface getTarget() {
        return (Interface)this.myTarget;
    }
}

