/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFSSwitch.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfs.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.eodm.rdf.rdfbase.RDFProperty;
import org.eclipse.eodm.rdf.rdfbase.RDFSResource;
import org.eclipse.eodm.rdf.rdfs.*;


/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.eodm.rdf.rdfs.util.RDFSPackage
 * @generated
 */
public class RDFSSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static RDFSPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RDFSSwitch() {
		if (modelPackage == null) {
			modelPackage = RDFSPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case RDFSPackage.RDFS_CLASS: {
				RDFSClass rdfsClass = (RDFSClass)theEObject;
				Object result = caseRDFSClass(rdfsClass);
				if (result == null) result = caseRDFSResource(rdfsClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDFS_DATATYPE: {
				RDFSDatatype rdfsDatatype = (RDFSDatatype)theEObject;
				Object result = caseRDFSDatatype(rdfsDatatype);
				if (result == null) result = caseRDFSClass(rdfsDatatype);
				if (result == null) result = caseRDFSResource(rdfsDatatype);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDF_LIST: {
				RDFList rdfList = (RDFList)theEObject;
				Object result = caseRDFList(rdfList);
				if (result == null) result = caseRDFSResource(rdfList);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDFS_CONTAINER: {
				RDFSContainer rdfsContainer = (RDFSContainer)theEObject;
				Object result = caseRDFSContainer(rdfsContainer);
				if (result == null) result = caseRDFSResource(rdfsContainer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDF_ALT: {
				RDFAlt rdfAlt = (RDFAlt)theEObject;
				Object result = caseRDFAlt(rdfAlt);
				if (result == null) result = caseRDFSContainer(rdfAlt);
				if (result == null) result = caseRDFSResource(rdfAlt);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDF_BAG: {
				RDFBag rdfBag = (RDFBag)theEObject;
				Object result = caseRDFBag(rdfBag);
				if (result == null) result = caseRDFSContainer(rdfBag);
				if (result == null) result = caseRDFSResource(rdfBag);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDF_SEQ: {
				RDFSeq rdfSeq = (RDFSeq)theEObject;
				Object result = caseRDFSeq(rdfSeq);
				if (result == null) result = caseRDFSContainer(rdfSeq);
				if (result == null) result = caseRDFSResource(rdfSeq);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case RDFSPackage.RDFS_CONTAINER_MEMBERSHIP_PROPERTY: {
				RDFSContainerMembershipProperty rdfsContainerMembershipProperty = (RDFSContainerMembershipProperty)theEObject;
				Object result = caseRDFSContainerMembershipProperty(rdfsContainerMembershipProperty);
				if (result == null) result = caseRDFProperty(rdfsContainerMembershipProperty);
				if (result == null) result = caseRDFSResource(rdfsContainerMembershipProperty);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSClass(RDFSClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Datatype</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Datatype</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSDatatype(RDFSDatatype object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF List</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF List</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFList(RDFList object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSContainer(RDFSContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Alt</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Alt</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFAlt(RDFAlt object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Bag</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Bag</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFBag(RDFBag object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Seq</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Seq</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSeq(RDFSeq object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Container Membership Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Container Membership Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSContainerMembershipProperty(RDFSContainerMembershipProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDFS Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDFS Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFSResource(RDFSResource object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>RDF Property</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>RDF Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseRDFProperty(RDFProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //RDFSSwitch
