/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFProperty.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDF Property</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSdomain <em>RDFSdomain</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSrange <em>RDFSrange</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSsubPropertyOf <em>RDFSsubPropertyOf</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getSubProperty <em>subProperty</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFProperty()
 * @model
 * @generated
 */
public interface RDFProperty extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>RDFSdomain</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfs.RDFSClass}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForDomain <em>propertyForDomain</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Sdomain</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSdomain</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFProperty_RDFSdomain()
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForDomain
	 * @model type="org.eclipse.eodm.rdf.rdfs.RDFSClass" opposite="propertyForDomain"
	 * @generated
	 */
	EList getRDFSdomain();

	/**
	 * Returns the value of the '<em><b>RDFSrange</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfs.RDFSClass}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForRange <em>propertyForRange</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Srange</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSrange</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFProperty_RDFSrange()
	 * @see org.eclipse.eodm.rdf.rdfs.RDFSClass#getPropertyForRange
	 * @model type="org.eclipse.eodm.rdf.rdfs.RDFSClass" opposite="propertyForRange"
	 * @generated
	 */
	EList getRDFSrange();

	/**
	 * Returns the value of the '<em><b>RDFSsubPropertyOf</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFProperty}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getSubProperty <em>subProperty</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RDF Ssub Property Of</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFSsubPropertyOf</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFProperty_RDFSsubPropertyOf()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getSubProperty
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFProperty" opposite="subProperty"
	 * @generated
	 */
	EList getRDFSsubPropertyOf();

	/**
	 * Returns the value of the '<em><b>subProperty</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.RDFProperty}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSsubPropertyOf <em>RDFSsubPropertyOf</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Property</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>subProperty</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFProperty_SubProperty()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFProperty#getRDFSsubPropertyOf
	 * @model type="org.eclipse.eodm.rdf.rdfbase.RDFProperty" opposite="RDFSsubPropertyOf"
	 * @generated
	 */
	EList getSubProperty();

} // RDFProperty
