/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.valuespec;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ValueSpecificationParserUtil {
    public static String getEditString(ValueSpecification valueSpecification) {
        UMLSwitch<String> valueSpecificationSwitch = new UMLSwitch<String>(){

            public String caseDuration(Duration duration) {
                return ValueSpecificationParserUtil.getEditString(duration.getExpr());
            }

            public String caseExpression(Expression expression) {
                EList operands;
                StringBuffer expressionDenotation = new StringBuffer();
                String symbol = expression.getSymbol();
                if (symbol != null) {
                    expressionDenotation.append(symbol);
                }
                if (!(operands = expression.getOperands()).isEmpty()) {
                    expressionDenotation.append('(');
                    Iterator operandsIterator = operands.iterator();
                    while (operandsIterator.hasNext()) {
                        ValueSpecification operand = (ValueSpecification)operandsIterator.next();
                        expressionDenotation.append(ValueSpecificationParserUtil.getEditString(operand));
                        if (!operandsIterator.hasNext()) continue;
                        expressionDenotation.append(',');
                    }
                    expressionDenotation.append('(');
                }
                return expressionDenotation.toString();
            }

            public String caseInstanceValue(InstanceValue instanceValue) {
                InstanceSpecification instanceSpecification = instanceValue.getInstance();
                if (instanceSpecification == null) {
                    return "";
                }
                return instanceSpecification.getName();
            }

            public String caseInterval(Interval interval) {
                ValueSpecification min = interval.getMin();
                ValueSpecification max = interval.getMax();
                if (min == null && max == null) {
                    return "";
                }
                StringBuffer intervalDenotation = new StringBuffer();
                if (min != null) {
                    intervalDenotation.append(ValueSpecificationParserUtil.getEditString(min));
                }
                intervalDenotation.append("..");
                if (max != null) {
                    intervalDenotation.append(ValueSpecificationParserUtil.getEditString(max));
                }
                return (String)super.caseInterval(interval);
            }

            public String caseLiteralBoolean(LiteralBoolean literalBoolean) {
                return literalBoolean.isValue() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
            }

            public String caseLiteralInteger(LiteralInteger literalInteger) {
                return Integer.toString(literalInteger.getValue());
            }

            public String caseLiteralNull(LiteralNull literalNull) {
                return "null";
            }

            public String caseLiteralString(LiteralString literalString) {
                String value = literalString.getValue();
                return value != null ? value : "";
            }

            public String caseLiteralUnlimitedNatural(LiteralUnlimitedNatural literalUnlimitedNatural) {
                return "*";
            }

            public String caseOpaqueExpression(OpaqueExpression opaqueExpression) {
                StringBuffer opaqueExpressionDenotation = new StringBuffer();
                EList languages = opaqueExpression.getLanguages();
                if (!languages.isEmpty()) {
                    opaqueExpressionDenotation.append('{');
                    Iterator languagesIterator = languages.iterator();
                    while (languagesIterator.hasNext()) {
                        opaqueExpressionDenotation.append((String)languagesIterator.next());
                    }
                    opaqueExpressionDenotation.append('}');
                }
                EList bodies = opaqueExpression.getBodies();
                Iterator bodiesIterator = bodies.iterator();
                while (bodiesIterator.hasNext()) {
                    opaqueExpressionDenotation.append((String)bodiesIterator.next());
                    if (!bodiesIterator.hasNext()) continue;
                    opaqueExpressionDenotation.append(' ');
                }
                return opaqueExpressionDenotation.toString();
            }

            public String caseTimeExpression(TimeExpression timeExpression) {
                return ValueSpecificationParserUtil.getEditString(timeExpression.getExpr());
            }
        };
        return (String)valueSpecificationSwitch.doSwitch((EObject)valueSpecification);
    }
}

