/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.parser.dependency;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.diagram.clazz.edit.commands.ChangeDependencyTypeCommand;
import org.eclipse.uml2.diagram.clazz.part.CustomMessages;
import org.eclipse.uml2.diagram.parser.assist.FixedSetCompletionProcessor;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyTypeParser
implements ISemanticParser {
    private static final String NOT_APPLICABLE = CustomMessages.DependencyTypeParser_not_applicable;
    private static final String LABEL_DEPENDENCY_SHORT = "";
    private static final String LABEL_DEPENDENCY_FULL = "dependency";
    private static final String LABEL_ABSTRACTION = "abstraction";
    private static final String LABEL_USAGE = "usage";
    private static final String LABEL_SUBSTITUTION = "substitute";
    private final ViewSwitch myViewSwitch = new ViewSwitch();
    private final EditSwitch myEditSwitch = new EditSwitch();
    private HashMap<String, EClass> myEditStringToType;
    private final FixedSetCompletionProcessor myCompletionProcessor = new FixedSetCompletionProcessor(new String[]{"dependency", "abstraction", "substitute", "usage"});
    private static final String QUOTE_FORMAT = "\u00ab{0}\u00bb";

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        this.myCompletionProcessor.setContext(this.doAdapt(element));
        return this.myCompletionProcessor;
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        if (!(element instanceof Dependency)) {
            return Collections.emptyList();
        }
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(element);
        result.add(element.eContainer());
        return result;
    }

    public String getEditString(IAdaptable element, int flags) {
        EObject dependency = this.doAdapt(element);
        return dependency == null ? NOT_APPLICABLE : (String)this.getEditSwitch().doSwitch(dependency);
    }

    public String getPrintString(IAdaptable element, int flags) {
        EObject subject = this.doAdapt(element);
        return subject == null ? NOT_APPLICABLE : (String)this.getViewSwitch().doSwitch(subject);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        EObject dependency = this.doAdapt(element);
        if (dependency == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EClass type = this.getType(newString);
        if (dependency.eClass().equals(type)) {
            return IdentityCommand.INSTANCE;
        }
        ConnectionEditPart editPart = this.getSelectedEditPart();
        if (type == null || editPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new CommandProxy((Command)new ChangeDependencyTypeCommand(editPart, type));
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return this.isAffectingEvent(notification, 0);
    }

    public boolean isAffectingEvent(Object notification, int flags) {
        if (notification instanceof Notification) {
            Object feature = ((Notification)notification).getFeature();
            return UMLPackage.eINSTANCE.getPackage_PackagedElement().equals(feature);
        }
        return false;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return this.getType(editString) == null ? ParserEditStatus.UNEDITABLE_STATUS : ParserEditStatus.EDITABLE_STATUS;
    }

    private EObject doAdapt(IAdaptable adaptable) {
        return (EObject)adaptable.getAdapter(EObject.class);
    }

    private EClass getType(String newString) {
        if (newString == null) {
            newString = LABEL_DEPENDENCY_SHORT;
        }
        newString = newString.trim();
        return this.getEditStringToTypeTable().get(newString);
    }

    private ConnectionEditPart getSelectedEditPart() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        EditPart selected = (EditPart)((IStructuredSelection)selection).getFirstElement();
        if (selected instanceof LabelEditPart) {
            selected = selected.getParent();
        }
        return selected instanceof ConnectionEditPart ? (ConnectionEditPart)selected : null;
    }

    private HashMap<String, EClass> getEditStringToTypeTable() {
        if (this.myEditStringToType == null) {
            this.myEditStringToType = new HashMap<String, EClass>(){

                @Override
                public EClass put(String key, EClass value) {
                    EClass result = super.put(key, value);
                    super.put(NLS.bind((String)DependencyTypeParser.QUOTE_FORMAT, (Object[])new Object[]{key}), value);
                    return result;
                }
            };
            this.myEditStringToType.put(LABEL_DEPENDENCY_FULL, UMLPackage.eINSTANCE.getDependency());
            this.myEditStringToType.put(LABEL_DEPENDENCY_SHORT, UMLPackage.eINSTANCE.getDependency());
            this.myEditStringToType.put(LABEL_ABSTRACTION, UMLPackage.eINSTANCE.getAbstraction());
            this.myEditStringToType.put(LABEL_SUBSTITUTION, UMLPackage.eINSTANCE.getSubstitution());
            this.myEditStringToType.put(LABEL_USAGE, UMLPackage.eINSTANCE.getUsage());
        }
        return this.myEditStringToType;
    }

    private UMLSwitch<String> getViewSwitch() {
        return this.myViewSwitch;
    }

    private UMLSwitch<String> getEditSwitch() {
        return this.myEditSwitch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EditSwitch
    extends UMLSwitch<String> {
        private EditSwitch() {
        }

        public String defaultCase(EObject object) {
            return NOT_APPLICABLE;
        }

        public String caseDependency(Dependency object) {
            return DependencyTypeParser.LABEL_DEPENDENCY_FULL;
        }

        public String caseAbstraction(Abstraction object) {
            return this.quote(DependencyTypeParser.LABEL_ABSTRACTION);
        }

        public String caseUsage(Usage object) {
            return this.quote(DependencyTypeParser.LABEL_USAGE);
        }

        public String caseSubstitution(Substitution object) {
            return this.quote(DependencyTypeParser.LABEL_SUBSTITUTION);
        }

        protected String quote(String text) {
            return text;
        }

        /* synthetic */ EditSwitch(EditSwitch editSwitch, EditSwitch editSwitch2) {
            this();
        }
    }

    private static class ViewSwitch
    extends EditSwitch {
        private ViewSwitch() {
            super(null, null);
        }

        protected String quote(String text) {
            return NLS.bind((String)DependencyTypeParser.QUOTE_FORMAT, (Object[])new Object[]{text});
        }

        public String caseDependency(Dependency object) {
            return DependencyTypeParser.LABEL_DEPENDENCY_SHORT;
        }
    }
}

