/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uml2.articles;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.util.UML2Resource;

public abstract class UML2Article {
    public static boolean DEBUG = true;
    protected static final ResourceSet RESOURCE_SET = new ResourceSetImpl();

    protected static void out(String output) {
        if (DEBUG) {
            System.out.println(output);
        }
    }

    protected static void err(String error) {
        System.err.println(error);
    }

    protected static void registerResourceFactories() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml2", UML2Resource.Factory.INSTANCE);
    }

    protected static void registerPathmaps(URI uri) {
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
    }

    protected static void save(Package package_, URI uri) {
        Resource resource = RESOURCE_SET.createResource(uri);
        resource.getContents().add((Object)package_);
        try {
            resource.save(null);
            UML2Article.out("Done.");
        }
        catch (IOException ioe) {
            UML2Article.err(ioe.getMessage());
        }
    }

    protected static Package load(URI uri) {
        Package package_ = null;
        try {
            Resource resource = RESOURCE_SET.getResource(uri, true);
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UML2Package.eINSTANCE.getPackage());
        }
        catch (WrappedException we) {
            UML2Article.err(we.getMessage());
            System.exit(1);
        }
        return package_;
    }
}

