/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Kiarabu";
        final String metaValue_hy = "Kiarmenia";
        final String metaValue_bn = "Kibengali";
        final String metaValue_ccp = "Kichakma";
        final String metaValue_chr = "Kicherokee";
        final String metaValue_ka = "Kijojia";
        final String metaValue_el = "Kigiriki";
        final String metaValue_gu = "Kigujarati";
        final String metaValue_he = "Kiebrania";
        final String metaValue_ja = "Kijapani";
        final String metaValue_km = "Kikambodia";
        final String metaValue_kn = "Kikannada";
        final String metaValue_ko = "Kikorea";
        final String metaValue_lo = "Kilaosi";
        final String metaValue_la = "Kilatini";
        final String metaValue_mn = "Kimongolia";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Kioriya";
        final String metaValue_si = "Kisinhala";
        final String metaValue_su = "Kisunda";
        final String metaValue_te = "Kitelugu";
        final String metaValue_th = "Kithai";
        final String metaValue_bo = "Kitibeti";
        final String metaValue_vai = "Kivai";
        final String metaValue_type_co_standard = "Mpangilio wa Kawaida";
        final Object[][] data = new Object[][] {
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Kaskazini" },
            { "005", "Amerika Kusini" },
            { "009", "Oceania" },
            { "011", "Afrika ya Magharibi" },
            { "013", "Amerika ya Kati" },
            { "014", "Afrika ya Mashariki" },
            { "015", "Afrika ya Kaskazini" },
            { "017", "Afrika ya Kati" },
            { "018", "Afrika ya Kusini" },
            { "019", "Amerika" },
            { "021", "Amerika ya Kaskazini" },
            { "029", "Karibiani" },
            { "030", "Asia ya Mashariki" },
            { "034", "Asia ya Kusini" },
            { "035", "Asia ya Kusini Mashariki" },
            { "039", "Ulaya ya Kusini" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Eneo la Mikronesia" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Asia ya Kati" },
            { "145", "Asia ya Magharibi" },
            { "150", "Ulaya" },
            { "151", "Ulaya ya Mashariki" },
            { "154", "Ulaya ya Kaskazini" },
            { "155", "Ulaya ya Magharibi" },
            { "202", "Afrika ya Kusini mwa Jangwa la Sahara" },
            { "419", "Amerika ya Kilatini" },
            { "AC", "Kisiwa cha Ascension" },
            { "AD", "Andorra" },
            { "AE", "Falme za Kiarabu" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua na Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antaktiki" },
            { "AR", "Ajentina" },
            { "AS", "Samoa ya Marekani" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Visiwa vya Aland" },
            { "AZ", "Azerbaijani" },
            { "BA", "Bosnia na Hezegovina" },
            { "BB", "Babadosi" },
            { "BD", "Bangladeshi" },
            { "BE", "Ubelgiji" },
            { "BF", "Bukinafaso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahareni" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Uholanzi ya Karibiani" },
            { "BR", "Brazil" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Kisiwa cha Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Visiwa vya Cocos (Keeling)" },
            { "CD", "Jamhuri ya Kidemokrasia ya Kongo" },
            { "CF", "Jamhuri ya Afrika ya Kati" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Uswisi" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Visiwa vya Cook" },
            { "CL", "Chile" },
            { "CM", "Kameruni" },
            { "CN", "Uchina" },
            { "CO", "Kolombia" },
            { "CP", "Kisiwa cha Clipperton" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curacao" },
            { "CX", "Kisiwa cha Krismasi" },
            { "CY", "Saiprasi" },
            { "CZ", "Chechia" },
            { "DE", "Ujerumani" },
            { "DG", "Diego Garcia" },
            { "DJ", "Jibuti" },
            { "DK", "Denmaki" },
            { "DM", "Dominika" },
            { "DO", "Jamhuri ya Dominika" },
            { "DZ", "Aljeria" },
            { "EA", "Ceuta na Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Misri" },
            { "EH", "Sahara Magharibi" },
            { "ER", "Eritrea" },
            { "ES", "Uhispania" },
            { "ET", "Ethiopia" },
            { "EU", "Umoja wa Ulaya" },
            { "EZ", "Jumuiya ya Ulaya" },
            { "FI", "Ufini" },
            { "FJ", "Fiji" },
            { "FK", "Visiwa vya Falkland" },
            { "FM", "Mikronesia" },
            { "FO", "Visiwa vya Faroe" },
            { "FR", "Ufaransa" },
            { "GA", "Gabon" },
            { "GB", "Ufalme wa Muungano" },
            { "GD", "Grenada" },
            { "GE", "Jojia" },
            { "GF", "Guiana ya Ufaransa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Gine" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea ya Ikweta" },
            { "GR", "Ugiriki" },
            { "GS", "Visiwa vya Georgia Kusini na Sandwich Kusini" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginebisau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kisiwa cha Heard na Visiwa vya McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "IC", "Visiwa vya Kanari" },
            { "ID", "Indonesia" },
            { "IE", "Ayalandi" },
            { "IL", "Israeli" },
            { "IM", "Kisiwa cha Man" },
            { "IN", "India" },
            { "IO", "Eneo la Uingereza katika Bahari Hindi" },
            { "IQ", "Iraki" },
            { "IR", "Iran" },
            { "IS", "Aisilandi" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japani" },
            { "KE", "Kenya" },
            { "KG", "Kirigizistani" },
            { "KH", "Kambodia" },
            { "KI", "Kiribati" },
            { "KM", "Komoro" },
            { "KN", "St. Kitts na Nevis" },
            { "KP", "Korea Kaskazini" },
            { "KR", "Korea Kusini" },
            { "KW", "Kuwait" },
            { "KY", "Visiwa vya Cayman" },
            { "KZ", "Kazakistani" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaska" },
            { "MH", "Visiwa vya Marshall" },
            { "MK", "Masedonia ya Kaskazini" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Makau SAR China" },
            { "MP", "Visiwa vya Mariana vya Kaskazini" },
            { "MQ", "Martinique" },
            { "MR", "Moritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Morisi" },
            { "MV", "Maldivi" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "MY", "Malesia" },
            { "MZ", "Msumbiji" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Kisiwa cha Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragwa" },
            { "NL", "Uholanzi" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nyuzilandi" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polynesia ya Ufaransa" },
            { "PG", "Papua New Guinea" },
            { "PH", "Ufilipino" },
            { "PK", "Pakistani" },
            { "PL", "Poland" },
            { "PM", "Santapierre na Miquelon" },
            { "PN", "Visiwa vya Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Maeneo ya Palestina" },
            { "PT", "Ureno" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania ya Nje" },
            { "RE", "Reunion" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Urusi" },
            { "RW", "Rwanda" },
            { "SA", "Saudia" },
            { "SB", "Visiwa vya Solomon" },
            { "SC", "Ushelisheli" },
            { "SD", "Sudan" },
            { "SE", "Uswidi" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard na Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Siera Leoni" },
            { "SM", "San Marino" },
            { "SN", "Senegali" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "Sudan Kusini" },
            { "ST", "Sao Tome na Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Visiwa vya Turks na Caicos" },
            { "TD", "Chad" },
            { "TF", "Himaya za Kusini za Kifaranza" },
            { "TG", "Togo" },
            { "TH", "Tailandi" },
            { "TJ", "Tajikistani" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Uturuki" },
            { "TT", "Trinidad na Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Visiwa Vidogo vya Nje vya Marekani" },
            { "UN", "Umoja wa Mataifa" },
            { "US", "Marekani" },
            { "UY", "Uruguay" },
            { "UZ", "Uzibekistani" },
            { "VA", "Mji wa Vatican" },
            { "VC", "St. Vincent na Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Visiwa vya Virgin, Uingereza" },
            { "VI", "Visiwa vya Virgin, Marekani" },
            { "VN", "Vietnamu" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis na Futuna" },
            { "WS", "Samoa" },
            { "XA", "Lafudhi Bandia" },
            { "XB", "Lafudhi Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemeni" },
            { "YT", "Mayotte" },
            { "ZA", "Afrika Kusini" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Eneo lisilojulikana" },
            { "aa", "Kiafar" },
            { "ab", "Kiabkhazi" },
            { "af", "Kiafrikana" },
            { "ak", "Kiakani" },
            { "am", "Kiamhari" },
            { "an", "Kiaragoni" },
            { "ar", metaValue_ar },
            { "as", "Kiassam" },
            { "av", "Kiavari" },
            { "ay", "Kiaymara" },
            { "az", "Kiazerbaijani" },
            { "ba", "Kibashkiri" },
            { "be", "Kibelarusi" },
            { "bg", "Kibulgaria" },
            { "bi", "Kibislama" },
            { "bm", "Kibambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Kibretoni" },
            { "bs", "Kibosnia" },
            { "ca", "Kikatalani" },
            { "ce", "Kichechenia" },
            { "ch", "Kichamorro" },
            { "co", "Kikosikani" },
            { "cs", "Kicheki" },
            { "cu", "Kislovakia cha Kanisa" },
            { "cv", "Kichuvash" },
            { "cy", "Kiwelisi" },
            { "da", "Kidenmaki" },
            { "de", "Kijerumani" },
            { "dv", "Kidivehi" },
            { "dz", "Kizongkha" },
            { "ee", "Kiewe" },
            { "el", metaValue_el },
            { "en", "Kiingereza" },
            { "eo", "Kiesperanto" },
            { "es", "Kihispania" },
            { "et", "Kiestonia" },
            { "eu", "Kibaski" },
            { "fa", "Kiajemi" },
            { "ff", "Kifulani" },
            { "fi", "Kifini" },
            { "fj", "Kifiji" },
            { "fo", "Kifaroe" },
            { "fr", "Kifaransa" },
            { "fy", "Kifrisia cha Magharibi" },
            { "ga", "Kiayalandi" },
            { "gd", "Kigaeli cha Uskoti" },
            { "gl", "Kigalisi" },
            { "gn", "Kiguarani" },
            { "gu", metaValue_gu },
            { "gv", "Kimanx" },
            { "ha", "Kihausa" },
            { "he", metaValue_he },
            { "hi", "Kihindi" },
            { "hr", "Kikorasia" },
            { "ht", "Kihaiti" },
            { "hu", "Kihungaria" },
            { "hy", metaValue_hy },
            { "hz", "Kiherero" },
            { "ia", "Kiintalingua" },
            { "id", "Kiindonesia" },
            { "ie", "lugha ya kisayansi" },
            { "ig", "Kiigbo" },
            { "ii", "Kiyi cha Sichuan" },
            { "io", "Kiido" },
            { "is", "Kiisilandi" },
            { "it", "Kiitaliano" },
            { "iu", "Kiinuktituti" },
            { "ja", metaValue_ja },
            { "jv", "Kijava" },
            { "ka", metaValue_ka },
            { "kg", "Kikongo" },
            { "ki", "Kikikuyu" },
            { "kj", "Kikwanyama" },
            { "kk", "Kikazakh" },
            { "kl", "Kikalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kikanuri" },
            { "ks", "Kikashmiri" },
            { "ku", "Kikurdi" },
            { "kv", "Kikomi" },
            { "kw", "Kikorni" },
            { "ky", "Kikyrgyz" },
            { "la", metaValue_la },
            { "lb", "Kilasembagi" },
            { "lg", "Kiganda" },
            { "li", "Limburgish" },
            { "ln", "Kilingala" },
            { "lo", metaValue_lo },
            { "lt", "Kilithuania" },
            { "lu", "Kiluba-Katanga" },
            { "lv", "Kilatvia" },
            { "mg", "Kimalagasi" },
            { "mh", "Kimashale" },
            { "mi", "Kimaori" },
            { "mk", "Kimacedonia" },
            { "ml", "Kimalayalamu" },
            { "mn", metaValue_mn },
            { "mr", "Kimarathi" },
            { "ms", "Kimalei" },
            { "mt", "Kimalta" },
            { "my", "Kiburma" },
            { "na", "Kinauru" },
            { "nb", "Kinorwe cha Bokmal" },
            { "nd", "Kindebele cha Kaskazini" },
            { "ne", "Kinepali" },
            { "ng", "Kindonga" },
            { "nl", "Kiholanzi" },
            { "nn", "Kinorwe cha Nynorsk" },
            { "no", "Kinorwe" },
            { "nr", "Kindebele" },
            { "nv", "Kinavajo" },
            { "ny", "Kinyanja" },
            { "oc", "Kiokitani" },
            { "om", "Kioromo" },
            { "or", metaValue_or },
            { "os", "Kiosetia" },
            { "pa", "Kipunjabi" },
            { "pl", "Kipolandi" },
            { "ps", "Kipashto" },
            { "pt", "Kireno" },
            { "qu", "Kikechua" },
            { "rm", "Kiromanshi" },
            { "rn", "Kirundi" },
            { "ro", "Kiromania" },
            { "ru", "Kirusi" },
            { "rw", "Kinyarwanda" },
            { "sa", "Kisanskriti" },
            { "sc", "Kisardinia" },
            { "sd", "Kisindhi" },
            { "se", "Kisami cha Kaskazini" },
            { "sg", "Kisango" },
            { "sh", "Kiserbia-kroeshia" },
            { "si", metaValue_si },
            { "sk", "Kislovakia" },
            { "sl", "Kislovenia" },
            { "sm", "Kisamoa" },
            { "sn", "Kishona" },
            { "so", "Kisomali" },
            { "sq", "Kialbania" },
            { "sr", "Kiserbia" },
            { "ss", "Kiswati" },
            { "st", "Kisotho" },
            { "su", metaValue_su },
            { "sv", "Kiswidi" },
            { "sw", "Kiswahili" },
            { "ta", "Kitamili" },
            { "te", metaValue_te },
            { "tg", "Kitajiki" },
            { "th", metaValue_th },
            { "ti", "Kitigrinya" },
            { "tk", "Kiturukimeni" },
            { "tn", "Kitswana" },
            { "to", "Kitonga" },
            { "tr", "Kituruki" },
            { "ts", "Kitsonga" },
            { "tt", "Kitatari" },
            { "tw", "Twi" },
            { "ty", "Kitahiti" },
            { "ug", "Kiuyghur" },
            { "uk", "Kiukraini" },
            { "ur", "Kiurdu" },
            { "uz", "Kiuzbeki" },
            { "ve", "Kivenda" },
            { "vi", "Kivietinamu" },
            { "vo", "Kivolapuk" },
            { "wa", "Kiwaloon" },
            { "wo", "Kiwolofu" },
            { "xh", "Kixhosa" },
            { "yi", "Kiyiddi" },
            { "yo", "Kiyoruba" },
            { "zh", "Kichina" },
            { "zu", "Kizulu" },
            { "ace", "Kiacheni" },
            { "ach", "Kiakoli" },
            { "ada", "Kiadangme" },
            { "ady", "Kiadyghe" },
            { "agq", "Kiaghem" },
            { "ain", "Kiainu" },
            { "ale", "Kialeut" },
            { "alt", "Kialtai" },
            { "ang", "Kiingereza cha Kale" },
            { "ann", "Kiobolo" },
            { "anp", "Kiangika" },
            { "arc", "Kiaramu" },
            { "arn", "Kimapuche" },
            { "arp", "Kiarapaho" },
            { "arq", "Kiarabu cha Algeria" },
            { "ars", "Kiarabu cha Najdi" },
            { "arz", "Kiarabu cha Misri" },
            { "asa", "Kiasu" },
            { "ast", "Kiasturia" },
            { "atj", "Kiatikamekw" },
            { "awa", "Kiawadhi" },
            { "ban", "Kibali" },
            { "bas", "Kibasaa" },
            { "bax", "Kibamun" },
            { "bbj", "Kighomala" },
            { "bej", "Kibeja" },
            { "bem", "Kibemba" },
            { "bez", "Kibena" },
            { "bfd", "Kibafut" },
            { "bgn", "Kibalochi cha Magharibi" },
            { "bho", "Kibhojpuri" },
            { "bin", "Kibini" },
            { "bkm", "Kikom" },
            { "bla", "Kisiksika" },
            { "brx", "Kibodo" },
            { "bug", "Kibugini" },
            { "bum", "Kibulu" },
            { "byn", "Kiblin" },
            { "byv", "Kimedumba" },
            { "cay", "Kikayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Kichebuano" },
            { "cgg", "Kichiga" },
            { "chk", "Kichukisi" },
            { "chm", "Kimari" },
            { "cho", "Kichoktao" },
            { "chp", "Kichipewyani" },
            { "chr", metaValue_chr },
            { "chy", "Kicheyeni" },
            { "ckb", "Kikurdi cha Sorani" },
            { "clc", "Kichikotini" },
            { "cop", "Kikhufti" },
            { "crg", "Kimichifu" },
            { "crj", "Kikrii cha Kusini Mashariki" },
            { "crk", "Kikri (Maeneo Tambarare)" },
            { "crl", "Kikrii cha Kaskazini Mashariki" },
            { "crm", "Kikrii cha Moose" },
            { "crr", "Kipamliko cha Carolina" },
            { "crs", "Krioli ya Shelisheli" },
            { "csw", "Kiomushkego" },
            { "dak", "Kidakota" },
            { "dar", "Kidaragwa" },
            { "dav", "Kitaita" },
            { "dgr", "Kidogrib" },
            { "dje", "Kizarma" },
            { "doi", "Kidogri" },
            { "dsb", "Kisobia cha Chini" },
            { "dua", "Kiduala" },
            { "dyo", "Kijola-Fonyi" },
            { "dyu", "Kijula" },
            { "dzg", "Kidazaga" },
            { "ebu", "Kiembu" },
            { "efi", "Kiefik" },
            { "egy", "Kimisri" },
            { "eka", "Kiekajuk" },
            { "ewo", "Kiewondo" },
            { "fil", "Kifilipino" },
            { "fon", "Kifon" },
            { "frc", "Kifaransa cha Kajuni" },
            { "fro", "Kifaransa cha Kale" },
            { "frr", "Kifrisia cha Kaskazini" },
            { "frs", "Kifrisia cha Mashariki" },
            { "fur", "Kifriulian" },
            { "gaa", "Ga" },
            { "gag", "Kigagauz" },
            { "gba", "Kigbaya" },
            { "gez", "Kige\u2019ez" },
            { "gil", "Kikiribati" },
            { "gor", "Kigorontalo" },
            { "grc", "Kiyunani" },
            { "gsw", "Kijerumani cha Uswisi" },
            { "guz", "Kikisii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Kihaida" },
            { "haw", "Kihawai" },
            { "hax", "Kihaida cha Kusini" },
            { "hil", "Kihiligaynon" },
            { "hit", "Kihiti" },
            { "hmn", "Kihmong" },
            { "hsb", "Kisobia cha Ukanda wa Juu" },
            { "hup", "Hupa" },
            { "hur", "Kihalkomelemi" },
            { "iba", "Kiiban" },
            { "ibb", "Kiibibio" },
            { "ikt", "Kiinuktituti cha Kanada Magharibi" },
            { "ilo", "Kiilocano" },
            { "inh", "Kiingush" },
            { "jbo", "Lojban" },
            { "jgo", "Kingomba" },
            { "jmc", "Kimachame" },
            { "kab", "Kikabylia" },
            { "kac", "Kachin" },
            { "kaj", "Kijju" },
            { "kam", "Kikamba" },
            { "kbd", "Kikabardian" },
            { "kbl", "Kikanembu" },
            { "kcg", "Kityap" },
            { "kde", "Kimakonde" },
            { "kea", "Kikabuverdianu" },
            { "kfo", "Kikoro" },
            { "kgp", "Kikaingang" },
            { "kha", "Kikhasi" },
            { "khq", "Kikoyra Chiini" },
            { "kkj", "Lugha ya Kako" },
            { "kln", "Kikalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Kikomi-Permyak" },
            { "kok", "Kikonkani" },
            { "kpe", "Kikpelle" },
            { "krc", "Kikarachay-Balkar" },
            { "krl", "Karjala" },
            { "kru", "Kurukh" },
            { "ksb", "Kisambaa" },
            { "ksf", "Kibafia" },
            { "ksh", "Kicologne" },
            { "kum", "Kumyk" },
            { "kwk", "Kikwak\u02bcwala" },
            { "lad", "Kiladino" },
            { "lag", "Kirangi" },
            { "lam", "Lamba" },
            { "lez", "Kilezighian" },
            { "lil", "Kilillooet" },
            { "lkt", "Kilakota" },
            { "lol", "Kimongo" },
            { "lou", "Kikrioli cha Louisiana" },
            { "loz", "Kilozi" },
            { "lrc", "Kiluri cha Kaskazini" },
            { "lsm", "Kisaamia" },
            { "lua", "Kiluba-Lulua" },
            { "lun", "Kilunda" },
            { "luo", "Kijaluo" },
            { "lus", "Kimizo" },
            { "luy", "Kiluhya" },
            { "mad", "Kimadura" },
            { "maf", "Kimafa" },
            { "mag", "Kimagahi" },
            { "mai", "Kimaithili" },
            { "mak", "Kimakasar" },
            { "mas", "Kimaasai" },
            { "mde", "Kimaba" },
            { "mdf", "Lugha ya Moksha" },
            { "men", "Kimende" },
            { "mer", "Kimeru" },
            { "mfe", "Kimoriseni" },
            { "mgh", "Kimakhuwa-Meetto" },
            { "mgo", "Kimeta" },
            { "mic", "Mi\u2019kmaq" },
            { "min", "Kiminangkabau" },
            { "mni", "Kimanipuri" },
            { "moe", "Kiinnu-aimun" },
            { "moh", "Lugha ya Mohawk" },
            { "mos", "Kimoore" },
            { "mua", "Kimundang" },
            { "mul", "Lugha nyingi" },
            { "mus", "Kikriki" },
            { "mwl", "Kimirandi" },
            { "myv", "Kierzya" },
            { "mzn", "Kimazanderani" },
            { "nap", "Kinapoli" },
            { "naq", "Kinama" },
            { "nds", "Kisaksoni" },
            { "new", "Kinewari" },
            { "nia", "Kiniasi" },
            { "niu", "Kiniuea" },
            { "nmg", "Kikwasio" },
            { "nnh", "Lugha ya Ngiemboon" },
            { "nog", "Kinogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Kisotho cha Kaskazini" },
            { "nus", "Kinuer" },
            { "nwc", "Kinewari cha kale" },
            { "nym", "Kinyamwezi" },
            { "nyn", "Kinyankole" },
            { "nyo", "Kinyoro" },
            { "nzi", "Kinzema" },
            { "ojb", "Kiojibwa cha Kaskazini Magharibi" },
            { "ojc", "Kiojibwa cha kati" },
            { "ojs", "Kikrii cha Oji" },
            { "ojw", "Kiojibwa cha Magharibi" },
            { "oka", "Kiokanagani" },
            { "pag", "Kipangasinan" },
            { "pam", "Kipampanga" },
            { "pap", "Kipapiamento" },
            { "pau", "Kipalau" },
            { "pcm", "Pijini ya Nigeria" },
            { "peo", "Kiajemi cha Kale" },
            { "pis", "Kipijini" },
            { "pqm", "Kimaliseet-Passamaquoddy" },
            { "prg", "Kiprussia" },
            { "quc", "K\u02bciche\u02bc" },
            { "rap", "Kirapanui" },
            { "rar", "Kirarotonga" },
            { "rhg", "Kirohingya" },
            { "rof", "Kirombo" },
            { "rup", "Kiaromania" },
            { "rwk", "Lugha ya Rwa" },
            { "sad", "Kisandawe" },
            { "sah", "Kisakha" },
            { "sam", "Kiaramu cha Wasamaria" },
            { "saq", "Kisamburu" },
            { "sat", "Kisantali" },
            { "sba", "Kingambay" },
            { "sbp", "Kisangu" },
            { "scn", "Kisicilia" },
            { "sco", "Kiskoti" },
            { "sdh", "Kikurdi cha Kusini" },
            { "seh", "Kisena" },
            { "ses", "Kikoyraboro Senni" },
            { "shi", "Kitachelhit" },
            { "shn", "Kishan" },
            { "shu", "Kiarabu cha Chad" },
            { "slh", "Lugha ya Lushootseed ya Kusini" },
            { "sma", "Kisami cha Kusini" },
            { "smj", "Kisami cha Lule" },
            { "smn", "Kisami cha Inari" },
            { "sms", "Kisami cha Skolt" },
            { "snk", "Kisoninke" },
            { "srn", "Lugha ya Sranan Tongo" },
            { "ssy", "Kisaho" },
            { "str", "Kisalishi cha Straiti" },
            { "suk", "Kisukuma" },
            { "sus", "Kisusu" },
            { "swb", "Shikomor" },
            { "syr", "Lugha ya Syriac" },
            { "tce", "Kitutchone cha Kusini" },
            { "tem", "Kitemne" },
            { "teo", "Kiteso" },
            { "tet", "Kitetum" },
            { "tgx", "Kitagishi" },
            { "tht", "Kitahltani" },
            { "tig", "Kitigre" },
            { "tlh", "Kiklingoni" },
            { "tli", "Kitlingiti" },
            { "tok", "Kitoki Pona" },
            { "tpi", "Kitokpisin" },
            { "trv", "Kitaroko" },
            { "ttm", "Kitutchone cha Kaskazini" },
            { "tum", "Kitumbuka" },
            { "tvl", "Kituvalu" },
            { "twq", "Kitasawak" },
            { "tyv", "Kituva" },
            { "tzm", "Kitamazighati cha Atlasi ya Kati" },
            { "udm", "Kiudmurt" },
            { "umb", "Umbundu" },
            { "und", "Lugha isiyojulikana" },
            { "vai", metaValue_vai },
            { "vun", "Kivunjo" },
            { "wae", "Kiwalser" },
            { "wal", "Kiwolaytta" },
            { "war", "Kiwaray" },
            { "wbp", "Kiwarlpiri" },
            { "wuu", "Kichina cha Wu" },
            { "xal", "Kikalmyk" },
            { "xog", "Kisoga" },
            { "yao", "Kiyao" },
            { "yav", "Kiyangben" },
            { "ybb", "Kiyemba" },
            { "yrl", "Kinheengatu" },
            { "yue", "Kikantoni" },
            { "zgh", "Kiberber Sanifu cha Moroko" },
            { "zun", "Kizuni" },
            { "zxx", "Hakuna maudhui ya lugha" },
            { "zza", "Kizaza" },
            { "Adlm", "Kiadlamu" },
            { "Arab", metaValue_ar },
            { "Aran", "Kinastaliki" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "Kibopomofo" },
            { "Brai", "Nukta nundu" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Silabi Zilizounganishwa za Wakazi Asili wa Kanada" },
            { "Cher", metaValue_chr },
            { "Cyrl", "Kisiriliki" },
            { "Deva", "Kidevanagari" },
            { "Ethi", "Kiethiopia" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Kigurmukhi" },
            { "Hanb", "Kihan chenye Bopomofo" },
            { "Hang", "Kihangul" },
            { "Hani", "Kihan" },
            { "Hans", "Rahisi" },
            { "Hant", "Cha jadi" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hrkt", "Hati za Kijapani" },
            { "Jamo", "Jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Kikatakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "Kimalayalam" },
            { "Mong", metaValue_mn },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Myama" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Kiol Chiki" },
            { "Orya", metaValue_or },
            { "Rohg", "Kihanifi" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", "Kisiriaki" },
            { "Taml", "Kitamil" },
            { "Telu", metaValue_te },
            { "Tfng", "Kitifinagh" },
            { "Thaa", "Kithaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "Kiyii" },
            { "Zmth", "Hati za kihisabati" },
            { "Zsye", "Emoji" },
            { "Zsym", "Alama" },
            { "Zxxx", "Haijaandikwa" },
            { "Zyyy", "Kawaida" },
            { "Zzzz", "Hati isiyojulikana" },
            { "en_CA", "Kiingereza (Canada)" },
            { "en_GB", "Kiingereza (Uingereza)" },
            { "es_ES", "Kihispania (Ulaya)" },
            { "fa_AF", "Kiajemi (Afganistani)" },
            { "fr_CA", "Kifaransa (Canada)" },
            { "nl_BE", "Kiflemi" },
            { "pt_BR", "Kireno (Brazili)" },
            { "pt_PT", "Kireno (Ulaya)" },
            { "ro_MD", "Kimoldova cha Romania" },
            { "ar_001", "Kiarabu sanifu" },
            { "es_419", "Kihispania (Amerika ya Latini)" },
            { "key.ca", "Kalenda" },
            { "key.cf", "Mpangilio wa Sarafu" },
            { "key.co", "Mpangilio" },
            { "key.cu", "Sarafu" },
            { "key.hc", "Kipindi cha saa (12 au 24)" },
            { "key.lb", "Mtindo wa Kukata Mstari" },
            { "key.ms", "Mfumo wa Vipimo" },
            { "key.nu", "Nambari" },
            { "key.tz", "Saa za Eneo" },
            { "key.va", "Lahaja za Lugha" },
            { "zh_Hans", "Kichina (Kilichorahisishwa)" },
            { "zh_Hant", "Kichina cha Jadi" },
            { "type.ca.roc", "Kalenda ya Jamhuri ya Uchina" },
            { "type.hc.h11", "Kipindi cha saa 12 (0\u201311)" },
            { "type.hc.h12", "Kipindi cha saa 12 (1\u201312)" },
            { "type.hc.h23", "Kipindi cha saa 24 (0\u201323)" },
            { "type.hc.h24", "Kipindi cha saa 24 (1\u201324)" },
            { "type.m0.bgn", "Mtindo wa kunukuu wa US BGN" },
            { "type.nu.arab", "Nambari za Kiarabu/Kihindi" },
            { "type.nu.armn", "Nambari za Kiarmenia" },
            { "type.nu.beng", "Nambari za Kibengali" },
            { "type.nu.cakm", "Nambari za Kichakma" },
            { "type.nu.deva", "Nambari za Kidevanagari" },
            { "type.nu.ethi", "Nambari za Kiethiopia" },
            { "type.nu.geor", "Nambari za Kigeorgia" },
            { "type.nu.grek", "Nambari za Kigiriki" },
            { "type.nu.gujr", "Nambari za Kigujarati" },
            { "type.nu.guru", "Nambari za Kigurmukhi" },
            { "type.nu.hans", "Nambari za Kichina Rahisi" },
            { "type.nu.hant", "Nambari za Kichina cha Jadi" },
            { "type.nu.hebr", "Nambari za Kiebrania" },
            { "type.nu.java", "Nambari za Kijava" },
            { "type.nu.jpan", "Nambari za Kijapani" },
            { "type.nu.khmr", "Nambari za Kikambodia" },
            { "type.nu.knda", "Nambari za Kikannada" },
            { "type.nu.laoo", "Nambari za Kilao" },
            { "type.nu.latn", "Nambari za Nchi za Magharibi" },
            { "type.nu.mlym", "Nambari za Malayalam" },
            { "type.nu.mong", "Nambari za Kimongolia" },
            { "type.nu.mtei", "Nambari za Meetei Mayek" },
            { "type.nu.mymr", "Nambari za Myanmar" },
            { "type.nu.olck", "Nambari za Kiol Chiki" },
            { "type.nu.orya", "Nambari za Kioriya" },
            { "type.nu.taml", "Nambari za Kitamil cha Jadi" },
            { "type.nu.telu", "Nambari za Kitelugu" },
            { "type.nu.thai", "Nambari za Kithai" },
            { "type.nu.tibt", "Nambari za Kitibeti" },
            { "type.nu.vaii", "Nambari za Kivai" },
            { "type.ca.dangi", "Kalenda ya Dangi" },
            { "type.co.ducet", "Mpangilio Chaguo-Msingi wa Unicode" },
            { "type.lb.loose", "Mtindo Pana wa Kukata Mstari" },
            { "type.nu.roman", "Nambari za Kirumi" },
            { "type.ca.coptic", "Kalenda ya Koptiki" },
            { "type.ca.hebrew", "Kalenda ya Kiebrania" },
            { "type.ca.indian", "Kalenda ya Taifa ya India" },
            { "type.co.pinyin", "Mpangilio wa Kipinyin" },
            { "type.co.search", "Utafutaji wa Kijumla" },
            { "type.co.stroke", "Mpangilio wa Mikwaju" },
            { "type.co.unihan", "Mpangilio wa Mikwaju ya Shina" },
            { "type.d0.fwidth", "Upana kamili" },
            { "type.d0.hwidth", "Nusu upana" },
            { "type.lb.normal", "Mtindo wa Kawaida wa Kukata Mstari" },
            { "type.lb.strict", "Mtindo Finyu wa Kukata Mstari" },
            { "type.m0.ungegn", "Mtindo wa kunukuu wa UN GEGN" },
            { "type.ms.metric", "Mfumo wa Metriki" },
            { "type.nu.native", "Nambari Asili" },
            { "type.ca.chinese", "Kalenda ya Kichina" },
            { "type.ca.islamic", "Kalenda ya Kiislamu" },
            { "type.ca.iso8601", "Kalenda ya ISO-8601" },
            { "type.ca.persian", "Kalenda ya Kiajemi" },
            { "type.cf.account", "Mpangilio wa Kihasibu wa Sarafu" },
            { "type.co.big5han", "Mpangilio wa Kichina cha Jadi - Big5" },
            { "type.d0.npinyin", "Ya Nambari" },
            { "type.nu.arabext", "Nambari za Kiarabu/Kihindi Zilizopanuliwa" },
            { "type.nu.armnlow", "Nambari Ndogo za Kiarmenia" },
            { "type.nu.finance", "Tarakimu za Kifedha" },
            { "type.nu.greklow", "Nambari Ndogo za Kigiriki" },
            { "type.nu.hanidec", "Nambari za Desimali za Kichina" },
            { "type.nu.hansfin", "Nambari za Kifedha za Kichina Rahisi" },
            { "type.nu.hantfin", "Nambari za Kifedha za Kichina cha Jadi" },
            { "type.nu.jpanfin", "Nambari za Kifedha za Kijapani" },
            { "type.nu.tamldec", "Nambari za Kitamil" },
            { "type.ca.buddhist", "Kalenda ya Kibuddha" },
            { "type.ca.ethiopic", "Kalenda ya Kiethiopia" },
            { "type.ca.japanese", "Kalenda ya Kijapani" },
            { "type.cf.standard", "Mpangilio wa Kawaida wa Sarafu" },
            { "type.co.phonetic", "Utaratibu wa Kupanga Fonetiki" },
            { "type.co.reformed", "Mpangilio Uliorekebishwa" },
            { "type.co.searchjl", "Tafuta kwa Konsonanti Halisi ya Hangul" },
            { "type.co.standard", metaValue_type_co_standard },
            { "type.ms.uksystem", "Mfumo wa Vipimo wa Uingereza" },
            { "type.ms.ussystem", "Mfumo wa Vipimo wa Marekani" },
            { "type.nu.fullwide", "Nambari za Upana Kamili" },
            { "type.nu.romanlow", "Nambari Ndogo za Kirumi" },
            { "type.ca.gregorian", "Kalenda ya Kigregori" },
            { "type.co.gb2312han", "Mpangilio wa Kichina Rahisi - GB2312" },
            { "type.co.phonebook", "Mpangilio wa Orodha za Nambari za Simu" },
            { "type.co.dictionary", "Mpangilio wa Kamusi" },
            { "type.co.traditional", metaValue_type_co_standard },
            { "type.nu.traditional", "Tarakimu za Jadi" },
            { "type.ca.islamic-civil", "Kalenda ya Kiislamu/Rasmi" },
            { "type.ca.islamic-umalqura", "Kalenda ya kiislamu (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Kalenda ya Kiethiopia ya Amete Alem" },
        };
        return data;
    }
}
