/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EClassConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EClassifierConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.EValidatorConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ConstrainingURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.TypeURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;

public abstract class AbstractConstraintLocator
implements ConstraintLocator,
ConstraintLocator.Descriptor {
    public static void initialize() {
        ValidityManager.addConstraintLocator("http://www.eclipse.org/emf/2002/Ecore", EClassConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator("http://www.eclipse.org/emf/2002/Ecore", EClassifierConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator("http://www.eclipse.org/emf/2002/Ecore", EValidatorConstraintLocator.INSTANCE);
        ValidityManager.addConstraintLocator(null, EValidatorConstraintLocator.INSTANCE);
    }

    protected @NonNull Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> createLeafConstrainingNode(@Nullable Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> map, @NonNull ValidityModel validityModel, @NonNull EObject constrainingType, @NonNull Object constrainingObject, @NonNull String label) {
        List<LeafConstrainingNode> constraints;
        LeafConstrainingNode constraint = validityModel.createLeafConstrainingNode();
        constraint.setConstraintLocator(this);
        constraint.setLabel(label);
        constraint.setConstrainingObject(constrainingObject);
        if (map == null) {
            map = new HashMap<EObject, List<LeafConstrainingNode>>();
        }
        if ((constraints = map.get(constrainingType)) == null) {
            constraints = new ArrayList<LeafConstrainingNode>();
            map.put(constrainingType, constraints);
        }
        constraints.add(constraint);
        return map;
    }

    @Override
    public @NonNull Set<@NonNull TypeURI> getAllTypes(@NonNull ValidityManager validityManager, @NonNull EObject constrainingObject) {
        HashSet<@NonNull TypeURI> allTypes = new HashSet<TypeURI>();
        allTypes.add(validityManager.getTypeURI(constrainingObject));
        if (constrainingObject instanceof EClass) {
            for (EClass eSuperClass : ((EClass)constrainingObject).getEAllSuperTypes()) {
                if (eSuperClass == null) continue;
                allTypes.add(validityManager.getTypeURI((EObject)eSuperClass));
            }
        }
        return allTypes;
    }

    @Override
    public @NonNull EObject getConstrainingType(@NonNull EObject constrainedType, @NonNull Object constrainingObject) {
        return constrainedType;
    }

    @Override
    public @Nullable ConstrainingURI getConstrainingURI(@NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (resource.getURI() == null) {
            return null;
        }
        @NonNull URI uri = resource.getURI().appendFragment(resource.getURIFragment(eObject));
        return new ConstrainingURI(uri);
    }

    @Override
    public @NonNull ConstraintLocator getConstraintLocator() {
        return this;
    }

    @Override
    public @Nullable Object getImage() {
        return null;
    }

    @Override
    public @Nullable Collection<@NonNull Resource> getImports(@NonNull EPackage ePackage, @NonNull Resource resource) {
        return null;
    }

    @Override
    public @NonNull String getLabel(@NonNull EModelElement eObject) {
        StringBuilder s = new StringBuilder();
        if (eObject instanceof ENamedElement) {
            EObject eContainer = eObject.eContainer();
            if (eContainer instanceof ENamedElement) {
                s.append(String.valueOf(((ENamedElement)eContainer).getName()) + "::");
            }
            s.append(((ENamedElement)eObject).getName());
        } else {
            s.append(String.valueOf(eObject));
        }
        return s.toString();
    }

    protected @NonNull Severity getSeverity(@NonNull Diagnostic diagnostic) {
        Severity severity;
        switch (diagnostic.getSeverity()) {
            case 0: {
                severity = Severity.OK;
                break;
            }
            case 1: {
                severity = Severity.INFO;
                break;
            }
            case 2: {
                severity = Severity.WARNING;
                break;
            }
            case 4: {
                severity = Severity.ERROR;
                break;
            }
            case 8: {
                severity = Severity.FATAL;
                break;
            }
            default: {
                severity = Severity.UNKNOWN;
            }
        }
        assert (severity != null);
        return severity;
    }

    @Override
    public @Nullable String getSourceExpression(@NonNull LeafConstrainingNode node) {
        return null;
    }

    @Override
    public @Nullable Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        return null;
    }

    @Override
    public @Nullable TypeURI getTypeURI(@NonNull ValidityManager validityManager, @NonNull EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (resource.getURI() == null) {
            return null;
        }
        @NonNull URI uri = resource.getURI().appendFragment(resource.getURIFragment(eObject));
        return new TypeURI(uri);
    }

    @Override
    public @Nullable Set<@NonNull TypeURI> getTypeURIs(@NonNull ValidityManager validityManager, @NonNull EObject validatableObject) {
        return null;
    }

    public String toString() {
        return "\"" + this.getName() + "\"";
    }

    @Override
    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        result.setDiagnostic("Unimplemented validate for " + this.getClass().getName());
        result.setSeverity(Severity.FATAL);
    }
}

