/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.service.Actionable;
import aQute.bnd.service.Strategy;
import aQute.bnd.version.Version;
import java.util.Map;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryEntry;
import org.eclipse.pde.bnd.ui.model.repo.ResourceProvider;
import org.eclipse.pde.bnd.ui.model.repo.VersionFinder;
import org.osgi.resource.Resource;

public class RepositoryBundleVersion
extends RepositoryEntry
implements Actionable,
ResourceProvider {
    private final Version version;
    private final RepositoryBundle bundle;

    public RepositoryBundleVersion(RepositoryBundle bundle, final Version version) {
        super(bundle.getRepo(), bundle.getBsn(), new VersionFinder(version.toString(), Strategy.EXACT){

            @Override
            Version findVersion() throws Exception {
                return version;
            }
        });
        this.bundle = bundle;
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public RepositoryBundle getParentBundle() {
        return this.bundle;
    }

    public String toString() {
        return "RepositoryBundleVersion [version=" + String.valueOf(this.version) + ", bundle=" + String.valueOf(this.bundle) + "]";
    }

    public String title(Object ... target) throws Exception {
        try {
            String s;
            if (this.bundle.getRepo() instanceof Actionable && (s = ((Actionable)this.bundle.getRepo()).title(new Object[]{this.bundle.getBsn(), this.version})) != null) {
                return s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getVersion().toString();
    }

    public String tooltip(Object ... target) throws Exception {
        try {
            String s;
            if (this.bundle.getRepo() instanceof Actionable && (s = ((Actionable)this.bundle.getRepo()).tooltip(new Object[]{this.bundle.getBsn(), this.version})) != null) {
                return s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Map<String, Runnable> actions(Object ... target) throws Exception {
        Map map = null;
        try {
            if (this.bundle.getRepo() instanceof Actionable) {
                map = ((Actionable)this.bundle.getRepo()).actions(new Object[]{this.bundle.getBsn(), this.version});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public String getText() {
        try {
            return this.title(new Object[0]);
        }
        catch (Exception e) {
            return this.version.toString();
        }
    }

    @Override
    public Resource getResource() {
        return this.bundle.getResource();
    }
}

