/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroupCore;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManagerCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public class ModifierChangeCorrectionProposalCore
extends LinkedCorrectionProposalCore {
    private IBinding fBinding;
    private ASTNode fNode;
    private int fIncludedModifiers;
    private int fExcludedModifiers;

    public ModifierChangeCorrectionProposalCore(String label, ICompilationUnit targetCU, IBinding binding, ASTNode node, int includedModifiers, int excludedModifiers, int relevance) {
        super(label, targetCU, (ASTRewrite)null, relevance);
        this.fBinding = binding;
        this.fNode = node;
        this.fIncludedModifiers = includedModifiers;
        this.fExcludedModifiers = excludedModifiers;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit(this.fNode);
        ASTNode boundNode = astRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
        } else {
            CompilationUnit newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
        }
        if (declNode != null) {
            TypeDeclaration typeDecl;
            MethodDeclaration methodDecl;
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            if (declNode.getNodeType() == 59) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)declNode;
                ASTNode parent = declNode.getParent();
                if (parent instanceof FieldDeclaration) {
                    FieldDeclaration fieldDecl = (FieldDeclaration)parent;
                    if (fieldDecl.fragments().size() > 1 && fieldDecl.getParent() instanceof AbstractTypeDeclaration) {
                        VariableDeclarationRewrite.rewriteModifiers(fieldDecl, new VariableDeclarationFragment[]{fragment}, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, null);
                        return rewrite;
                    }
                } else if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        VariableDeclarationRewrite.rewriteModifiers(varDecl, new VariableDeclarationFragment[]{fragment}, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, null);
                        return rewrite;
                    }
                } else {
                    boolean cfr_ignored_0 = parent instanceof VariableDeclarationExpression;
                }
                declNode = parent;
            } else if (declNode.getNodeType() == 31 && !(methodDecl = (MethodDeclaration)declNode).isConstructor()) {
                IMethodBinding methodBinding = methodDecl.resolveBinding();
                if (methodDecl.getBody() == null && methodBinding != null && Modifier.isAbstract((int)methodBinding.getModifiers()) && Modifier.isStatic((int)this.fIncludedModifiers)) {
                    String placeHolder;
                    Expression expression;
                    ICompilationUnit unit = this.getCompilationUnit();
                    String delimiter = unit.findRecommendedLineSeparator();
                    String bodyStatement = "";
                    Block body = ast.newBlock();
                    rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)body, null);
                    Type returnType = methodDecl.getReturnType2();
                    if (returnType != null && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType, methodDecl.getExtraDimensions())) != null) {
                        ReturnStatement returnStatement = ast.newReturnStatement();
                        returnStatement.setExpression(expression);
                        bodyStatement = ASTNodes.asFormattedString((ASTNode)returnStatement, 0, delimiter, FormatterProfileManagerCore.getProjectSettings(unit.getJavaProject()));
                    }
                    if ((placeHolder = CodeGeneration.getMethodBodyContent(unit, methodBinding.getDeclaringClass().getName(), methodBinding.getName(), false, bodyStatement, delimiter)) != null) {
                        ReturnStatement todoNode = (ReturnStatement)rewrite.createStringPlaceholder(placeHolder, 41);
                        body.statements().add(todoNode);
                    }
                }
            }
            ModifierRewrite listRewrite = ModifierRewrite.create(rewrite, declNode);
            LinkedProposalPositionGroupCore.PositionInformation trackedDeclNode = listRewrite.setModifiers(this.fIncludedModifiers, this.fExcludedModifiers, null);
            LinkedProposalPositionGroupCore positionGroup = new LinkedProposalPositionGroupCore("group");
            positionGroup.addPosition(trackedDeclNode);
            if (declNode.getNodeType() == 31 && (this.fIncludedModifiers & 0x400) != 0 && (typeDecl = ASTNodes.getFirstAncestorOrNull(declNode, TypeDeclaration.class)) != null && !typeDecl.isInterface() && !Modifier.isAbstract((int)typeDecl.getModifiers())) {
                ModifierRewrite listRewrite2 = ModifierRewrite.create(rewrite, (ASTNode)typeDecl);
                LinkedProposalPositionGroupCore.PositionInformation trackedDeclNode2 = listRewrite2.setModifiers(typeDecl.getModifiers() | 0x400, null);
                positionGroup.addPosition(trackedDeclNode2);
            }
            this.getLinkedProposalModel().addPositionGroup(positionGroup);
            if (boundNode != null) {
                this.setEndPosition(rewrite.track(this.fNode));
            }
            return rewrite;
        }
        return null;
    }
}

