/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.util;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AbstractEditHelperAdviceConfiguration;
import org.eclipse.papyrus.infra.types.AbstractMatcherConfiguration;
import org.eclipse.papyrus.infra.types.Activator;
import org.eclipse.papyrus.infra.types.AdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.AdviceConfiguration;
import org.eclipse.papyrus.infra.types.Annotation;
import org.eclipse.papyrus.infra.types.ConfigurationElement;
import org.eclipse.papyrus.infra.types.ContainerConfiguration;
import org.eclipse.papyrus.infra.types.EditHelperAdviceConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredAdvice;
import org.eclipse.papyrus.infra.types.ExternallyRegisteredType;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.IdentifiedConfiguration;
import org.eclipse.papyrus.infra.types.InheritanceKind;
import org.eclipse.papyrus.infra.types.MatcherConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.NamedConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;

public class ElementTypesConfigurationsValidator
extends EObjectValidator {
    public static final String CONTEXT_REGISTRY_LOADING = "org.eclipse.papyrus.infra.types.registry_loading";
    public static final ElementTypesConfigurationsValidator INSTANCE = new ElementTypesConfigurationsValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.papyrus.infra.types";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String ABSTRACT_ADVICE_BINDING_CONFIGURATION__APPLY_TO_ALL_TYPES__EEXPRESSION = "applyToAllTypes = target.oclIsUndefined()";

    protected EPackage getEPackage() {
        return ElementTypesConfigurationsPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateElementTypeSetConfiguration((ElementTypeSetConfiguration)value, diagnostics, context);
            }
            case 1: {
                return this.validateConfigurationElement((ConfigurationElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateElementTypeConfiguration((ElementTypeConfiguration)value, diagnostics, context);
            }
            case 3: {
                return this.validateIconEntry((IconEntry)value, diagnostics, context);
            }
            case 4: {
                return this.validateAbstractAdviceBindingConfiguration((AbstractAdviceBindingConfiguration)value, diagnostics, context);
            }
            case 5: {
                return this.validateAdviceConfiguration((AdviceConfiguration)value, diagnostics, context);
            }
            case 6: {
                return this.validateContainerConfiguration((ContainerConfiguration)value, diagnostics, context);
            }
            case 7: {
                return this.validateAbstractMatcherConfiguration((AbstractMatcherConfiguration)value, diagnostics, context);
            }
            case 8: {
                return this.validateSpecializationTypeConfiguration((SpecializationTypeConfiguration)value, diagnostics, context);
            }
            case 9: {
                return this.validateAbstractEditHelperAdviceConfiguration((AbstractEditHelperAdviceConfiguration)value, diagnostics, context);
            }
            case 10: {
                return this.validateIdentifiedConfiguration((IdentifiedConfiguration)value, diagnostics, context);
            }
            case 11: {
                return this.validateNamedConfiguration((NamedConfiguration)value, diagnostics, context);
            }
            case 12: {
                return this.validateAnnotation((Annotation)value, diagnostics, context);
            }
            case 13: {
                return this.validateMetamodelTypeConfiguration((MetamodelTypeConfiguration)value, diagnostics, context);
            }
            case 14: {
                return this.validateEditHelperAdviceConfiguration((EditHelperAdviceConfiguration)value, diagnostics, context);
            }
            case 15: {
                return this.validateAdviceBindingConfiguration((AdviceBindingConfiguration)value, diagnostics, context);
            }
            case 16: {
                return this.validateMatcherConfiguration((MatcherConfiguration)value, diagnostics, context);
            }
            case 17: {
                return this.validateExternallyRegisteredType((ExternallyRegisteredType)value, diagnostics, context);
            }
            case 18: {
                return this.validateExternallyRegisteredAdvice((ExternallyRegisteredAdvice)value, diagnostics, context);
            }
            case 19: {
                return this.validateInheritanceKind((InheritanceKind)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateElementTypeSetConfiguration(ElementTypeSetConfiguration elementTypeSetConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(elementTypeSetConfiguration, diagnostics, context);
    }

    public boolean validateConfigurationElement(ConfigurationElement configurationElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(configurationElement, diagnostics, context);
    }

    public boolean validateElementTypeConfiguration(ElementTypeConfiguration elementTypeConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(elementTypeConfiguration, diagnostics, context);
    }

    public boolean validateIconEntry(IconEntry iconEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(iconEntry, diagnostics, context);
    }

    public boolean validateAbstractAdviceBindingConfiguration(AbstractAdviceBindingConfiguration abstractAdviceBindingConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(abstractAdviceBindingConfiguration, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(abstractAdviceBindingConfiguration, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractAdviceBindingConfiguration_apply_to_all_types(abstractAdviceBindingConfiguration, diagnostics, context);
        }
        return result;
    }

    public boolean validateAbstractAdviceBindingConfiguration_apply_to_all_types(AbstractAdviceBindingConfiguration abstractAdviceBindingConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(ElementTypesConfigurationsPackage.Literals.ABSTRACT_ADVICE_BINDING_CONFIGURATION, abstractAdviceBindingConfiguration, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL", "apply_to_all_types", ABSTRACT_ADVICE_BINDING_CONFIGURATION__APPLY_TO_ALL_TYPES__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAdviceConfiguration(AdviceConfiguration adviceConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(adviceConfiguration, diagnostics, context);
    }

    public boolean validateContainerConfiguration(ContainerConfiguration containerConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(containerConfiguration, diagnostics, context);
    }

    public boolean validateAbstractMatcherConfiguration(AbstractMatcherConfiguration abstractMatcherConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractMatcherConfiguration, diagnostics, context);
    }

    public boolean validateIdentifiedConfiguration(IdentifiedConfiguration identifiedConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(identifiedConfiguration, diagnostics, context);
    }

    public boolean validateNamedConfiguration(NamedConfiguration namedConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedConfiguration, diagnostics, context);
    }

    public boolean validateAnnotation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(annotation, diagnostics, context);
    }

    public boolean validateSpecializationTypeConfiguration(SpecializationTypeConfiguration specializationTypeConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(specializationTypeConfiguration, diagnostics, context);
    }

    public boolean validateAbstractEditHelperAdviceConfiguration(AbstractEditHelperAdviceConfiguration abstractEditHelperAdviceConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractEditHelperAdviceConfiguration, diagnostics, context);
    }

    public boolean validateMetamodelTypeConfiguration(MetamodelTypeConfiguration metamodelTypeConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(metamodelTypeConfiguration, diagnostics, context);
    }

    public boolean validateEditHelperAdviceConfiguration(EditHelperAdviceConfiguration editHelperAdviceConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(editHelperAdviceConfiguration, diagnostics, context);
    }

    public boolean validateAdviceBindingConfiguration(AdviceBindingConfiguration adviceBindingConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(adviceBindingConfiguration, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(adviceBindingConfiguration, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(adviceBindingConfiguration, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractAdviceBindingConfiguration_apply_to_all_types(adviceBindingConfiguration, diagnostics, context);
        }
        return result;
    }

    public boolean validateMatcherConfiguration(MatcherConfiguration matcherConfiguration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(matcherConfiguration, diagnostics, context);
    }

    public boolean validateExternallyRegisteredType(ExternallyRegisteredType externallyRegisteredType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(externallyRegisteredType, diagnostics, context);
    }

    public boolean validateExternallyRegisteredAdvice(ExternallyRegisteredAdvice externallyRegisteredAdvice, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(externallyRegisteredAdvice, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(externallyRegisteredAdvice, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(externallyRegisteredAdvice, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAbstractAdviceBindingConfiguration_apply_to_all_types(externallyRegisteredAdvice, diagnostics, context);
        }
        return result;
    }

    public boolean validateInheritanceKind(InheritanceKind inheritanceKind, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return Activator.INSTANCE;
    }

    protected void reportConstraintDelegateViolation(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String constraint, int severity, String source, int code) {
        block0 : switch (eClass.getClassifierID()) {
            case 4: {
                switch (constraint) {
                    case "apply_to_all_types": {
                        AbstractAdviceBindingConfiguration advice;
                        if (context != null && Boolean.TRUE.equals(context.get(CONTEXT_REGISTRY_LOADING))) {
                            severity = 2;
                        }
                        if ((advice = (AbstractAdviceBindingConfiguration)eObject).isApplyToAllTypes()) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, this.getString("_UI_apply_to_all_types_diagnostic", new Object[]{ElementTypesConfigurationsValidator.getObjectLabel((EObject)eObject, context)}), new Object[]{eObject, ElementTypesConfigurationsPackage.Literals.ABSTRACT_ADVICE_BINDING_CONFIGURATION__APPLY_TO_ALL_TYPES}));
                            break block0;
                        }
                        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, this.getString("_UI_no_target_diagnostic", new Object[]{ElementTypesConfigurationsValidator.getObjectLabel((EObject)eObject, context)}), new Object[]{eObject, ElementTypesConfigurationsPackage.Literals.ABSTRACT_ADVICE_BINDING_CONFIGURATION__TARGET}));
                        break block0;
                    }
                }
                super.reportConstraintDelegateViolation(eClass, eObject, diagnostics, context, constraint, severity, source, code);
                break;
            }
            default: {
                super.reportConstraintDelegateViolation(eClass, eObject, diagnostics, context, constraint, severity, source, code);
            }
        }
    }
}

