/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.resource.FileImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;

class URLImageDescriptor
extends ImageDescriptor
implements IAdaptable {
    private static long cumulativeTime;
    private static final String FILE_PROTOCOL = "file";
    private final String url;

    URLImageDescriptor(URL url) {
        super(true);
        this.url = url.toExternalForm();
    }

    public boolean equals(Object o) {
        if (!(o instanceof URLImageDescriptor)) {
            return false;
        }
        return ((URLImageDescriptor)o).url.equals(this.url);
    }

    @Override
    @Deprecated
    public ImageData getImageData() {
        return URLImageDescriptor.getImageData(URLImageDescriptor.getURL(this.url));
    }

    @Override
    public ImageData getImageData(int zoom) {
        return URLImageDescriptor.getImageData(this.url, zoom);
    }

    private static ImageData getImageData(String url, int zoom) {
        URL tempURL = URLImageDescriptor.getURL(url);
        if (tempURL != null) {
            URL xPathUrl;
            ImageData xdata;
            if (zoom == 100) {
                return URLImageDescriptor.getImageData(tempURL);
            }
            URL xUrl = URLImageDescriptor.getxURL(tempURL, zoom);
            if (xUrl != null && (xdata = URLImageDescriptor.getImageData(xUrl)) != null) {
                return xdata;
            }
            String xpath = FileImageDescriptor.getxPath(url, zoom);
            if (xpath != null && (xPathUrl = URLImageDescriptor.getURL(xpath)) != null) {
                return URLImageDescriptor.getImageData(xPathUrl);
            }
        }
        return null;
    }

    private static ImageData getImageData(URL url) {
        ImageData result = null;
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream in = URLImageDescriptor.getStream(url);){
                if (in != null) {
                    result = new ImageData(in);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SWTException e) {
            if (e.code != 40) {
                throw e;
            }
        }
        catch (IOException e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getLocalizedMessage(), (Throwable)e));
        }
        return result;
    }

    protected InputStream getStream() {
        return URLImageDescriptor.getStream(URLImageDescriptor.getURL(this.url));
    }

    private static InputStream getStream(URL url) {
        if (url == null) {
            return null;
        }
        try {
            URL platformURL;
            if (InternalPolicy.OSGI_AVAILABLE && (platformURL = FileLocator.find((URL)url)) != null) {
                url = platformURL;
            }
            return new BufferedInputStream(url.openStream());
        }
        catch (IOException e) {
            String path;
            if (InternalPolicy.DEBUG_LOG_URL_IMAGE_DESCRIPTOR_MISSING_2x && ((path = url.getPath()).endsWith("@2x.png") || path.endsWith("@1.5x.png"))) {
                String message = "High-resolution image missing: " + String.valueOf(url);
                Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", message, (Throwable)e));
            }
            return null;
        }
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + this.url + ")";
    }

    private static URL getxURL(URL url, int zoom) {
        String path = url.getPath();
        int dot = path.lastIndexOf(46);
        if (dot != -1 && (zoom == 150 || zoom == 200)) {
            String lead = path.substring(0, dot);
            String tail = path.substring(dot);
            if (InternalPolicy.DEBUG_LOAD_URL_IMAGE_DESCRIPTOR_2x_PNG_FOR_GIF && ".gif".equalsIgnoreCase(tail)) {
                tail = ".png";
            }
            String x = zoom == 150 ? "@1.5x" : "@2x";
            try {
                String file = lead + x + tail;
                if (url.getQuery() != null) {
                    file = file + "?" + url.getQuery();
                }
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
            }
            catch (MalformedURLException e) {
                Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return null;
    }

    private static String getFilePath(URL url, boolean logIOException) {
        String filePath;
        URL locatedURL;
        block9: {
            try {
                if (InternalPolicy.OSGI_AVAILABLE) break block9;
                if (FILE_PROTOCOL.equalsIgnoreCase(url.getProtocol())) {
                    return IPath.fromOSString((String)url.getFile()).toOSString();
                }
                return null;
            }
            catch (IOException e) {
                String path;
                if (logIOException) {
                    Policy.logException(e);
                } else if (InternalPolicy.DEBUG_LOG_URL_IMAGE_DESCRIPTOR_MISSING_2x && ((path = url.getPath()).endsWith("@2x.png") || path.endsWith("@1.5x.png"))) {
                    String message = "High-resolution image missing: " + String.valueOf(url);
                    Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", message, (Throwable)e));
                }
                return null;
            }
        }
        URL platformURL = FileLocator.find((URL)url);
        if (platformURL != null) {
            url = platformURL;
        }
        if (FILE_PROTOCOL.equalsIgnoreCase((locatedURL = FileLocator.toFileURL((URL)url)).getProtocol()) && Files.exists(Path.of(filePath = IPath.fromOSString((String)locatedURL.getPath()).toOSString(), new String[0]), new LinkOption[0])) {
            return filePath;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static URL getURL(String urlString) {
        URL result = null;
        try {
            result = new URL(urlString);
        }
        catch (MalformedURLException e) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", e.getLocalizedMessage(), (Throwable)e));
        }
        return result;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == URL.class) {
            return adapter.cast(URLImageDescriptor.getURL(this.url));
        }
        if (adapter == ImageFileNameProvider.class) {
            return adapter.cast(new URLImageFileNameProvider(this.url));
        }
        if (adapter == ImageDataProvider.class) {
            return adapter.cast(new URLImageDataProvider(this.url));
        }
        return null;
    }

    private static class URLImageDataProvider
    implements ImageDataProvider {
        private final String url;

        public URLImageDataProvider(String url) {
            this.url = url;
        }

        public ImageData getImageData(int zoom) {
            return URLImageDescriptor.getImageData(this.url, zoom);
        }
    }

    private static class URLImageFileNameProvider
    implements ImageFileNameProvider {
        private final String url;

        public URLImageFileNameProvider(String url) {
            this.url = url;
        }

        public String getImagePath(int zoom) {
            URL tempURL = URLImageDescriptor.getURL(this.url);
            if (tempURL != null) {
                URL xPathUrl;
                String xResult;
                boolean logIOException;
                boolean bl = logIOException = zoom == 100;
                if (zoom == 100) {
                    return URLImageDescriptor.getFilePath(tempURL, logIOException);
                }
                URL xUrl = URLImageDescriptor.getxURL(tempURL, zoom);
                if (xUrl != null && (xResult = URLImageDescriptor.getFilePath(xUrl, logIOException)) != null) {
                    return xResult;
                }
                String xpath = FileImageDescriptor.getxPath(this.url, zoom);
                if (xpath != null && (xPathUrl = URLImageDescriptor.getURL(xpath)) != null) {
                    return URLImageDescriptor.getFilePath(xPathUrl, logIOException);
                }
            }
            return null;
        }
    }
}

