/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.commands;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Stack;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;

public class CommandStack {
    public static final int POST_EXECUTE = 8;
    public static final int POST_REDO = 16;
    public static final int POST_UNDO = 32;
    public static final int POST_FLUSH = 256;
    public static final int POST_MARK_SAVE = 512;
    public static final int POST_MASK = 824;
    public static final int PRE_EXECUTE = 1;
    public static final int PRE_REDO = 2;
    public static final int PRE_UNDO = 4;
    public static final int PRE_FLUSH = 64;
    public static final int PRE_MARK_SAVE = 128;
    public static final int PRE_MASK = 199;
    private final List<CommandStackEventListener> eventListeners = new ArrayList<CommandStackEventListener>();
    @Deprecated
    protected List<CommandStackListener> listeners = new ArrayList<CommandStackListener>();
    private final Stack<Command> redoable = new Stack();
    private int saveLocation = 0;
    private final Stack<Command> undoable = new Stack();
    private int undoLimit = 0;

    public void addCommandStackEventListener(CommandStackEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Deprecated
    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public boolean canRedo() {
        if (this.redoable.isEmpty()) {
            return false;
        }
        return this.redoable.peek().canRedo();
    }

    public boolean canUndo() {
        if (this.undoable.isEmpty()) {
            return false;
        }
        return this.undoable.peek().canUndo();
    }

    public void dispose() {
        this.flushUndo();
        this.flushRedo();
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.flushRedo();
        this.notifyListeners(command, 1);
        try {
            command.execute();
            if (this.getUndoLimit() > 0) {
                while (this.undoable.size() >= this.getUndoLimit()) {
                    ((Command)this.undoable.remove(0)).dispose();
                    if (this.saveLocation <= -1) continue;
                    --this.saveLocation;
                }
            }
            if (this.saveLocation > this.undoable.size()) {
                this.saveLocation = -1;
            }
            this.undoable.push(command);
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 8);
        }
    }

    public void flush() {
        this.notifyListeners(null, 64);
        this.flushRedo();
        this.flushUndo();
        this.saveLocation = 0;
        this.notifyListeners();
        this.notifyListeners(null, 256);
    }

    private void flushRedo() {
        while (!this.redoable.isEmpty()) {
            this.redoable.pop().dispose();
        }
    }

    private void flushUndo() {
        while (!this.undoable.isEmpty()) {
            this.undoable.pop().dispose();
        }
    }

    public Object[] getCommands() {
        ArrayList<Command> commands = new ArrayList<Command>(this.undoable);
        int i = this.redoable.size() - 1;
        while (i >= 0) {
            commands.add((Command)this.redoable.get(i));
            --i;
        }
        return commands.toArray();
    }

    public Command getRedoCommand() {
        return this.redoable.isEmpty() ? null : this.redoable.peek();
    }

    public Command getUndoCommand() {
        return this.undoable.isEmpty() ? null : this.undoable.peek();
    }

    public int getUndoLimit() {
        return this.undoLimit;
    }

    public boolean isDirty() {
        return this.undoable.size() != this.saveLocation;
    }

    public void markSaveLocation() {
        this.notifyListeners(null, 128);
        this.saveLocation = this.undoable.size();
        this.notifyListeners();
        this.notifyListeners(null, 512);
    }

    @Deprecated
    protected void notifyListeners() {
        EventObject event = new EventObject(this);
        this.listeners.forEach(listener -> listener.commandStackChanged(event));
    }

    protected void notifyListeners(Command command, int state) {
        CommandStackEvent event = new CommandStackEvent(this, command, state);
        this.eventListeners.forEach(eventListener -> eventListener.stackChanged(event));
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = this.redoable.pop();
        this.notifyListeners(command, 2);
        try {
            command.redo();
            this.undoable.push(command);
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 16);
        }
    }

    public void removeCommandStackEventListener(CommandStackEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Deprecated
    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    public void setUndoLimit(int undoLimit) {
        this.undoLimit = undoLimit;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        Command command = this.undoable.pop();
        this.notifyListeners(command, 4);
        try {
            command.undo();
            this.redoable.push(command);
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 32);
        }
    }
}

