/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.FeatureModelDelta;
import org.eclipse.pde.internal.core.FeatureTable;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspaceFeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.Version;

public class FeatureModelManager {
    private FeatureTable fActiveModels;
    private FeatureTable fInactiveModels;
    private ExternalFeatureModelManager fExternalManager;
    private boolean fReloadExternalNeeded = false;
    private final WorkspaceFeatureModelManager fWorkspaceManager = new WorkspaceFeatureModelManager();
    private IModelProviderListener fProviderListener;
    private final ArrayList<IFeatureModelListener> fListeners = new ArrayList();

    public synchronized void shutdown() {
        if (this.fWorkspaceManager != null) {
            this.fWorkspaceManager.removeModelProviderListener(this.fProviderListener);
        }
        if (this.fExternalManager != null) {
            this.fExternalManager.removeModelProviderListener(this.fProviderListener);
        }
    }

    public boolean isInitialized() {
        return this.fActiveModels != null && !this.fReloadExternalNeeded;
    }

    private synchronized void init() {
        IFeatureModel[] models;
        if (this.fActiveModels != null) {
            if (this.fReloadExternalNeeded) {
                this.fReloadExternalNeeded = false;
                this.fExternalManager.initialize();
            }
            return;
        }
        this.fActiveModels = new FeatureTable();
        this.fInactiveModels = new FeatureTable();
        this.fProviderListener = this::handleModelsChanged;
        this.fWorkspaceManager.addModelProviderListener(this.fProviderListener);
        IFeatureModel[] iFeatureModelArray = models = this.fWorkspaceManager.getFeatureModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            this.fActiveModels.add(model);
            ++n2;
        }
        this.fExternalManager = new ExternalFeatureModelManager();
        this.fExternalManager.addModelProviderListener(this.fProviderListener);
        this.fReloadExternalNeeded = false;
        ITargetDefinition unresolvedRepoBasedtarget = null;
        try {
            unresolvedRepoBasedtarget = TargetPlatformHelper.getUnresolvedRepositoryBasedWorkspaceTarget();
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        if (unresolvedRepoBasedtarget != null && !P2TargetUtils.isProfileValid(unresolvedRepoBasedtarget)) {
            WorkspaceJob initializeExternalManager = new WorkspaceJob(PDECoreMessages.FeatureModelManager_initializingFeatureTargetPlatform){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    FeatureModelManager.this.fExternalManager.initialize();
                    return Status.OK_STATUS;
                }
            };
            initializeExternalManager.schedule();
        } else {
            this.fExternalManager.initialize();
        }
    }

    public IFeatureModel[] getModels() {
        this.init();
        IFeatureModel[] allModels = this.fActiveModels.getAll();
        ArrayList<IFeatureModel> valid = new ArrayList<IFeatureModel>(allModels.length);
        IFeatureModel[] iFeatureModelArray = allModels;
        int n = allModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.isValid()) {
                valid.add(model);
            }
            ++n2;
        }
        return valid.toArray(new IFeatureModel[valid.size()]);
    }

    public IFeatureModel[] getWorkspaceModels() {
        this.init();
        return this.fWorkspaceManager.getFeatureModels();
    }

    public IFeatureModel[] getExternalModels() {
        this.init();
        return this.fExternalManager.getModels();
    }

    public IFeatureModel getFeatureModel(IProject project) {
        this.init();
        return (IFeatureModel)this.fWorkspaceManager.getModel(project);
    }

    public IFeatureModel findFeatureModel(String id, String version) {
        this.init();
        IFeatureModel[] models = this.fActiveModels.get(id, version);
        if (VersionUtil.isEmptyVersion(version)) {
            return this.findFeatureModel(id);
        }
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.isValid()) {
                return model;
            }
            ++n2;
        }
        return null;
    }

    public IFeatureModel findFeatureModelRelaxed(String id, String version) {
        IFeatureModel model = this.findFeatureModel(id, version);
        if (model != null) {
            return model;
        }
        try {
            Version pvi = Version.parseVersion((String)version);
            return this.findFeatureModel(id, pvi.getMajor() + "." + pvi.getMinor() + "." + pvi.getMicro() + ".qualifier");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public IFeatureModel[] findFeatureModels(String id) {
        this.init();
        IFeatureModel[] models = this.fActiveModels.get(id);
        ArrayList<IFeatureModel> valid = new ArrayList<IFeatureModel>(models.length);
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.isValid()) {
                valid.add(model);
            }
            ++n2;
        }
        return valid.toArray(new IFeatureModel[valid.size()]);
    }

    public IFeatureModel findFeatureModel(String id) {
        IFeatureModel[] models = this.findFeatureModels(id);
        IFeatureModel result = null;
        IFeatureModel[] iFeatureModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (result == null) {
                result = model;
            } else {
                String version = result.getFeature().getVersion();
                String version2 = model.getFeature().getVersion();
                Version vid = Version.parseVersion((String)version);
                Version vid2 = Version.parseVersion((String)version2);
                if (VersionUtil.isGreaterOrEqualTo(vid2, vid)) {
                    result = model;
                }
            }
            ++n2;
        }
        return result;
    }

    private void handleModelsChanged(IModelProviderEvent e) {
        Object[] entries;
        this.init();
        IFeatureModelDelta delta = this.processEvent(e);
        Object[] objectArray = entries = this.fListeners.toArray();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object entry = objectArray[n2];
            ((IFeatureModelListener)entry).modelsChanged(delta);
            ++n2;
        }
    }

    private synchronized IFeatureModelDelta processEvent(IModelProviderEvent e) {
        IModel[] changed;
        FeatureTable.Idver idver;
        String version;
        String id;
        FeatureTable.Idver idver2;
        IFeatureModel model;
        IModel iModel;
        int i;
        FeatureModelDelta delta = new FeatureModelDelta();
        HashSet<FeatureTable.Idver> affectedIdVers = null;
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            i = 0;
            while (i < removed.length) {
                iModel = removed[i];
                if (iModel instanceof IFeatureModel) {
                    IFeatureModel cfr_ignored_0 = (IFeatureModel)iModel;
                    IFeatureModel cfr_ignored_1 = (IFeatureModel)iModel;
                    idver2 = this.fActiveModels.remove(model);
                    if (idver2 != null) {
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet<FeatureTable.Idver>();
                        }
                        affectedIdVers.add(idver2);
                        delta.add(model, 2);
                    } else {
                        this.fInactiveModels.remove(model);
                    }
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            i = 0;
            while (i < added.length) {
                iModel = added[i];
                if (iModel instanceof IFeatureModel) {
                    IFeatureModel cfr_ignored_2 = (IFeatureModel)iModel;
                    IFeatureModel cfr_ignored_3 = (IFeatureModel)iModel;
                    if (model.getUnderlyingResource() != null) {
                        idver2 = this.fActiveModels.add(model);
                        delta.add(model, 1);
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet();
                        }
                        affectedIdVers.add(idver2);
                    } else if (model.isValid() && this.fInactiveModels.get(id = model.getFeature().getId(), version = model.getFeature().getVersion()).length <= 0) {
                        IFeatureModel[] activeModels;
                        IFeatureModel[] iFeatureModelArray = activeModels = this.fActiveModels.get(id, version);
                        int n = activeModels.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFeatureModel activeModel = iFeatureModelArray[n2];
                            if (activeModel.getUnderlyingResource() == null) {
                                // empty if block
                            }
                            ++n2;
                        }
                        idver = this.fInactiveModels.add(model);
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet();
                        }
                        affectedIdVers.add(idver);
                    }
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            changed = e.getChangedModels();
            i = 0;
            while (i < changed.length) {
                iModel = changed[i];
                if (iModel instanceof IFeatureModel) {
                    IFeatureModel cfr_ignored_4 = (IFeatureModel)iModel;
                    IFeatureModel cfr_ignored_5 = (IFeatureModel)iModel;
                    id = model.getFeature().getId();
                    version = model.getFeature().getVersion();
                    FeatureTable.Idver oldIdver = this.fActiveModels.get(model);
                    if (oldIdver != null && !oldIdver.equals(id, version)) {
                        idver = this.fActiveModels.add(model);
                        if (affectedIdVers == null) {
                            affectedIdVers = new HashSet();
                        }
                        affectedIdVers.add(oldIdver);
                        affectedIdVers.add(idver);
                    }
                }
                ++i;
            }
        }
        this.adjustExternalVisibility(delta, affectedIdVers);
        if ((e.getEventTypes() & 4) != 0) {
            changed = e.getChangedModels();
            i = 0;
            while (i < changed.length) {
                iModel = changed[i];
                if (iModel instanceof IFeatureModel) {
                    IFeatureModel cfr_ignored_6 = (IFeatureModel)iModel;
                    IFeatureModel cfr_ignored_7 = (IFeatureModel)iModel;
                    if (!delta.contains(model, 3)) {
                        delta.add(model, 4);
                    }
                }
                ++i;
            }
        }
        return delta;
    }

    private void adjustExternalVisibility(FeatureModelDelta delta, Set<FeatureTable.Idver> affectedIdVers) {
        if (affectedIdVers != null) {
            for (FeatureTable.Idver idver : affectedIdVers) {
                IFeatureModel[] models;
                IFeatureModel[] affectedModels = this.fActiveModels.get(idver);
                if (affectedModels.length > 1) {
                    IFeatureModel[] iFeatureModelArray = affectedModels;
                    int n = affectedModels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFeatureModel model = iFeatureModelArray[n2];
                        if (model.getUnderlyingResource() == null) {
                            this.fActiveModels.remove(model);
                            this.fInactiveModels.add(model);
                            delta.add(model, 2);
                        }
                        ++n2;
                    }
                }
                if (affectedModels.length > 0 || (models = this.fInactiveModels.get(idver)).length <= 0) continue;
                this.fInactiveModels.remove(models[0]);
                this.fActiveModels.add(models[0]);
                delta.add(models[0], 1);
            }
        }
    }

    public void addFeatureModelListener(IFeatureModelListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeFeatureModelListener(IFeatureModelListener listener) {
        if (this.fListeners.contains(listener)) {
            this.fListeners.remove(listener);
        }
    }

    public void targetReloaded() {
        this.fReloadExternalNeeded = true;
    }

    public IFeatureModel getDeltaPackFeature() {
        IFeatureModel model = this.findFeatureModel("org.eclipse.equinox.executable");
        if (model == null) {
            model = this.findFeatureModel("org.eclipse.platform.launchers");
        }
        return model;
    }

    public void removeFromWorkspaceFeature(IFeatureModel iFeatureModel) {
        if (this.fWorkspaceManager != null) {
            this.fWorkspaceManager.removeModel(iFeatureModel);
        }
    }
}

