/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdi.internal.event.ExceptionEventImpl;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.JDIDebugMessages;
import org.eclipse.jdt.internal.debug.core.JDIDebugOptions;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class EventDispatcher
implements Runnable {
    private final JDIDebugTarget fTarget;
    private volatile boolean fShutdown;
    private final HashMap<EventRequest, IJDIEventListener> fEventHandlers;
    private final Map<EventSet, List<DebugEvent>> fSetToQueue = new HashMap<EventSet, List<DebugEvent>>();

    public EventDispatcher(JDIDebugTarget target) {
        this.fEventHandlers = new HashMap(10);
        this.fTarget = target;
        this.fShutdown = false;
    }

    private void dispatch(EventSet eventSet) {
        IJDIEventListener listener;
        Event event;
        if (this.isShutdown()) {
            return;
        }
        if (JDIDebugOptions.DEBUG_JDI_EVENTS) {
            EventIterator eventIter = eventSet.eventIterator();
            StringBuilder buf = new StringBuilder("JDI Event Set: {\n");
            while (eventIter.hasNext()) {
                buf.append(eventIter.next());
                if (!eventIter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("}\n");
            JDIDebugOptions.trace(buf.toString());
        }
        EventIterator iter = eventSet.eventIterator();
        IJDIEventListener[] listeners = new IJDIEventListener[eventSet.size()];
        boolean vote = false;
        boolean resume = true;
        int index = -1;
        ArrayList<Event> deferredEvents = null;
        while (iter.hasNext()) {
            IJDIEventListener listener2;
            ++index;
            if (this.isShutdown()) {
                return;
            }
            Event event2 = iter.nextEvent();
            if (event2 == null) continue;
            listeners[index] = listener2 = this.fEventHandlers.get(event2.request());
            if (listener2 != null) {
                if (listener2 instanceof IJavaLineBreakpoint) {
                    try {
                        if (((IJavaLineBreakpoint)((Object)listener2)).isConditionEnabled()) {
                            if (deferredEvents == null) {
                                deferredEvents = new ArrayList<Event>(5);
                            }
                            deferredEvents.add(event2);
                            continue;
                        }
                    }
                    catch (CoreException exception) {
                        JDIDebugPlugin.log(exception);
                    }
                }
                vote = true;
                try {
                    try {
                        resume = listener2.handleEvent(event2, this.fTarget, !resume, eventSet) && resume;
                    }
                    finally {
                        this.enableGCForExceptionEvent(event2);
                    }
                }
                catch (Throwable t) {
                    EventDispatcher.logHandleEventError(listener2, event2, t);
                }
                continue;
            }
            if (event2 instanceof VMDeathEvent) {
                this.fTarget.handleVMDeath((VMDeathEvent)event2);
                this.shutdown();
                continue;
            }
            if (event2 instanceof VMDisconnectEvent) {
                this.fTarget.handleVMDisconnect((VMDisconnectEvent)event2);
                this.shutdown();
                continue;
            }
            if (!(event2 instanceof VMStartEvent)) continue;
            this.fTarget.handleVMStart((VMStartEvent)event2);
        }
        if (deferredEvents != null) {
            Iterator deferredIter = deferredEvents.iterator();
            while (deferredIter.hasNext()) {
                if (this.isShutdown()) {
                    return;
                }
                event = (Event)deferredIter.next();
                if (event == null || (listener = this.fEventHandlers.get(event.request())) == null) continue;
                vote = true;
                try {
                    try {
                        resume = listener.handleEvent(event, this.fTarget, !resume, eventSet) && resume;
                    }
                    catch (Throwable t) {
                        EventDispatcher.logHandleEventError(listener, event, t);
                        this.enableGCForExceptionEvent(event);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    this.enableGCForExceptionEvent(event);
                    throw throwable;
                }
                this.enableGCForExceptionEvent(event);
            }
        }
        ArrayList<Runnable> threadDeathRunnables = new ArrayList<Runnable>();
        index = -1;
        iter = eventSet.eventIterator();
        while (iter.hasNext()) {
            event = iter.nextEvent();
            if ((listener = listeners[++index]) == null) continue;
            if (event instanceof ThreadDeathEvent) {
                boolean res = resume;
                threadDeathRunnables.add(() -> listener.eventSetComplete(event, this.fTarget, !res, eventSet));
                continue;
            }
            listener.eventSetComplete(event, this.fTarget, !resume, eventSet);
        }
        this.fireEvents(eventSet);
        threadDeathRunnables.forEach(runnable -> DebugPlugin.getDefault().asyncExec(runnable));
        if (vote && resume) {
            try {
                eventSet.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (RuntimeException e) {
                try {
                    this.fTarget.targetRequestFailed(JDIDebugMessages.EventDispatcher_0, e);
                }
                catch (DebugException de) {
                    JDIDebugPlugin.log(de);
                }
            }
        }
    }

    private boolean requiresExpressionEvaluation(EventSet eventSet) {
        EventIterator iter = eventSet.eventIterator();
        while (iter.hasNext()) {
            IJDIEventListener listener;
            Event event = iter.nextEvent();
            if (event == null || !((listener = this.fEventHandlers.get(event.request())) instanceof IJavaLineBreakpoint)) continue;
            try {
                if (!((IJavaLineBreakpoint)((Object)listener)).isConditionEnabled()) continue;
                return true;
            }
            catch (CoreException coreException) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        VirtualMachine vm = this.fTarget.getVM();
        if (vm != null) {
            EventQueue q = vm.eventQueue();
            while (!this.isShutdown()) {
                try {
                    EventSet eventSet;
                    try {
                        eventSet = q.remove(1000L);
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        break;
                    }
                    if (eventSet == null) continue;
                    if (!this.requiresExpressionEvaluation(eventSet)) {
                        this.dispatch(eventSet);
                        continue;
                    }
                    AbstractDispatchJob job = new AbstractDispatchJob(this, "JDI Expression Evaluation Event Dispatch"){

                        protected IStatus run(IProgressMonitor monitor) {
                            this.dispatch(eventSet);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public void shutdown() {
        this.fShutdown = true;
        Job.getJobManager().cancel((Object)this);
    }

    private boolean isShutdown() {
        return this.fShutdown;
    }

    public void addJDIEventListener(IJDIEventListener listener, EventRequest request) {
        this.fEventHandlers.put(request, listener);
    }

    public void removeJDIEventListener(IJDIEventListener listener, EventRequest request) {
        this.fEventHandlers.remove(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(DebugEvent event, EventSet set) {
        Map<EventSet, List<DebugEvent>> map = this.fSetToQueue;
        synchronized (map) {
            List<DebugEvent> list = this.fSetToQueue.get(set);
            if (list == null) {
                list = new ArrayList<DebugEvent>(5);
                this.fSetToQueue.put(set, list);
            }
            list.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvents(EventSet set) {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null) {
            List<DebugEvent> list = null;
            Map<EventSet, List<DebugEvent>> map = this.fSetToQueue;
            synchronized (map) {
                list = this.fSetToQueue.remove(set);
            }
            if (list != null) {
                DebugEvent[] events = list.toArray(new DebugEvent[list.size()]);
                plugin.fireDebugEventSet(events);
            }
        }
    }

    private void enableGCForExceptionEvent(Event event) {
        if (event instanceof ExceptionEventImpl) {
            try {
                if (this.fTarget.isAvailable()) {
                    ((ExceptionEventImpl)event).enableExceptionGC();
                }
            }
            catch (VMDisconnectedException e) {
                if (this.fTarget.isAvailable()) {
                    JDIDebugPlugin.logError("Failed to enable GC for event: " + String.valueOf(event), e);
                }
            }
            catch (Throwable t) {
                JDIDebugPlugin.logError("Failed to enable GC for event: " + String.valueOf(event), t);
            }
        }
    }

    private static void logHandleEventError(IJDIEventListener listener, Event event, Throwable t) {
        JDIDebugPlugin.logError("Exception occurred while notifying listener: " + String.valueOf(listener) + ", with event: " + String.valueOf(event), t);
    }

    public abstract class AbstractDispatchJob
    extends Job {
        protected AbstractDispatchJob(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            return family == EventDispatcher.class || family == EventDispatcher.this;
        }

        public String toString() {
            try {
                return super.toString() + " for [" + EventDispatcher.this.fTarget.getName() + "]";
            }
            catch (DebugException debugException) {
                return super.toString();
            }
        }
    }
}

