/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.product.AbstractProductContentSection;
import org.eclipse.pde.internal.ui.editor.product.VersionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.NewFragmentProjectWizard;
import org.eclipse.pde.internal.ui.wizards.plugin.NewPluginProjectWizard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginSection
extends AbstractProductContentSection<PluginSection> {
    private static final List<String> BUTTON_LABELS;
    private static final List<Consumer<PluginSection>> BUTTON_HANDLERS;
    private static final int BTN_ADD;
    private static final int BTN_ADD_WORKING_SET;
    private static final int BTN_ADD_REQUIRED;
    private static final int BTN_REMOVE;
    private static final int BTN_REMOVE_ALL;
    private static final int BTN_PROPS;
    private Button fIncludeOptionalButton;
    private static final QualifiedName OPTIONAL_PROPERTY;

    static {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList handlers = new ArrayList();
        BTN_ADD = PluginSection.addButton(PDEUIMessages.Product_PluginSection_add, PluginSection::handleAdd, labels, handlers);
        BTN_ADD_WORKING_SET = PluginSection.addButton(PDEUIMessages.Product_PluginSection_working, PluginSection::handleAddWorkingSet, labels, handlers);
        BTN_ADD_REQUIRED = PluginSection.addButton(PDEUIMessages.Product_PluginSection_required, s -> PluginSection.handleAddRequired(s.getProduct().getPlugins(), s.fIncludeOptionalButton.getSelection()), labels, handlers);
        BTN_REMOVE = PluginSection.addButton(PDEUIMessages.PluginSection_remove, AbstractProductContentSection::handleRemove, labels, handlers);
        BTN_REMOVE_ALL = PluginSection.addButton(PDEUIMessages.Product_PluginSection_removeAll, PluginSection::handleRemoveAll, labels, handlers);
        BTN_PROPS = PluginSection.addButton(PDEUIMessages.Product_FeatureSection_properties, PluginSection::handleProperties, labels, handlers);
        BUTTON_LABELS = List.copyOf(labels);
        BUTTON_HANDLERS = List.copyOf(handlers);
        OPTIONAL_PROPERTY = new QualifiedName("org.eclipse.pde.ui", "product.includeOptional");
    }

    public PluginSection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, BUTTON_LABELS, BUTTON_HANDLERS, IProductPlugin.class::isInstance);
    }

    @Override
    void populateSection(Section section, Composite container, FormToolkit toolkit) {
        this.createAutoIncludeRequirementsButton(container, PDEUIMessages.Product_PluginSection_autoIncludeRequirements);
        new Label(container, 0);
        this.createOptionalDependenciesButton(container);
        this.configureTable(IProduct::getPlugins, new ViewerComparator());
        this.enableTableButtons(BTN_ADD, BTN_ADD_WORKING_SET, BTN_ADD_REQUIRED, BTN_PROPS);
        section.setText(PDEUIMessages.Product_PluginSection_title);
        section.setDescription(PDEUIMessages.Product_PluginSection_desc);
    }

    /*
     * WARNING - void declaration
     */
    private void createOptionalDependenciesButton(Composite container) {
        if (this.isEditable()) {
            IEditorInput input;
            this.fIncludeOptionalButton = new Button(container, 32);
            this.fIncludeOptionalButton.setText(PDEUIMessages.PluginSection_includeOptional);
            IEditorInput iEditorInput = input = this.getPage().getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                void fileEditorInput;
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
                IFile file = fileEditorInput.getFile();
                try {
                    this.fIncludeOptionalButton.setSelection("true".equals(file.getPersistentProperty(OPTIONAL_PROPERTY)));
                }
                catch (CoreException coreException) {}
            }
            this.fIncludeOptionalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                IEditorInput iEditorInput2 = input;
                if (iEditorInput2 instanceof IFileEditorInput) {
                    void fileEditorInput;
                    IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput2;
                    IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput2;
                    IFile file = fileEditorInput.getFile();
                    try {
                        file.setPersistentProperty(OPTIONAL_PROPERTY, this.fIncludeOptionalButton.getSelection() ? "true" : null);
                    }
                    catch (CoreException coreException) {}
                }
            }));
        }
    }

    @Override
    List<Action> getToolbarActions() {
        Action newPluginAction = PluginSection.createPushAction(PDEUIMessages.Product_PluginSection_newPlugin, PDEPluginImages.DESC_NEWPPRJ_TOOL, () -> PluginSection.handleNewPlugin(this));
        Action newFragmentAction = PluginSection.createPushAction(PDEUIMessages.Product_PluginSection_newFragment, PDEPluginImages.DESC_NEWFRAGPRJ_TOOL, () -> PluginSection.handleNewFragment(this));
        return List.of(newPluginAction, newFragmentAction);
    }

    static void handleNewFragment(AbstractProductContentSection<?> section) {
        NewFragmentProjectWizard wizard = new NewFragmentProjectWizard();
        wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            PluginSection.addPlugin(wizard.getFragmentId(), wizard.getFragmentVersion(), section);
        }
    }

    static void handleNewPlugin(AbstractProductContentSection<?> section) {
        NewPluginProjectWizard wizard = new NewPluginProjectWizard();
        wizard.init(PDEPlugin.getActiveWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
        if (dialog.open() == 0) {
            PluginSection.addPlugin(wizard.getPluginId(), wizard.getPluginVersion(), section);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void handleProperties(AbstractProductContentSection<?> section) {
        Object object;
        IStructuredSelection ssel = section.getTableSelection();
        if (ssel.size() == 1 && (object = ssel.getFirstElement()) instanceof IProductPlugin) {
            void plugin;
            IProductPlugin iProductPlugin = (IProductPlugin)object;
            IProductPlugin cfr_ignored_0 = (IProductPlugin)object;
            VersionDialog dialog = new VersionDialog(PDEPlugin.getActiveWorkbenchShell(), section.isEditable(), plugin.getVersion());
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 200);
            if (dialog.open() == 0) {
                plugin.setVersion(dialog.getVersion());
            }
        }
    }

    public static void handleAddRequired(IProductPlugin[] plugins, boolean includeOptional) {
        DependencyManager.Options[] optionsArray;
        if (plugins.length == 0) {
            return;
        }
        List<BundleDescription> list = Stream.of(plugins).map(plugin -> {
            String version = VersionUtil.isEmptyVersion((String)plugin.getVersion()) ? null : plugin.getVersion();
            return PluginRegistry.findModel((String)plugin.getId(), (String)version, (int)3, null);
        }).filter(Objects::nonNull).map(IPluginModelBase::getBundleDescription).toList();
        if (includeOptional) {
            DependencyManager.Options[] optionsArray2 = new DependencyManager.Options[2];
            optionsArray2[0] = DependencyManager.Options.INCLUDE_NON_TEST_FRAGMENTS;
            optionsArray = optionsArray2;
            optionsArray2[1] = DependencyManager.Options.INCLUDE_OPTIONAL_DEPENDENCIES;
        } else {
            DependencyManager.Options[] optionsArray3 = new DependencyManager.Options[1];
            optionsArray = optionsArray3;
            optionsArray3[0] = DependencyManager.Options.INCLUDE_NON_TEST_FRAGMENTS;
        }
        DependencyManager.Options[] options = optionsArray;
        Set dependencies = DependencyManager.findRequirementsClosure(list, (DependencyManager.Options[])options);
        IProduct product = plugins[0].getProduct();
        PluginSection.addPluginsWithSymbolicName(product, dependencies.stream().map(BundleDescription::getSymbolicName));
    }

    private void handleAddWorkingSet() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = manager.createWorkingSetSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), true);
        if (dialog.open() == 0) {
            IWorkingSet[] workingSets = dialog.getSelection();
            Stream<String> plugins = Stream.of(workingSets).flatMap(ws -> Stream.of(ws.getElements())).map(this::findModel).filter(Objects::nonNull).map(model -> model.getPluginBase().getId());
            PluginSection.addPluginsWithSymbolicName(this.getProduct(), plugins);
        }
    }

    private static void addPluginsWithSymbolicName(IProduct product, Stream<String> pluginIds) {
        IProductModelFactory factory = product.getModel().getFactory();
        IProductPlugin[] plugins = (IProductPlugin[])pluginIds.map(symbolicName -> {
            IProductPlugin plugin = factory.createPlugin();
            plugin.setId(symbolicName);
            return plugin;
        }).toArray(IProductPlugin[]::new);
        product.addPlugins(plugins);
    }

    @Override
    void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePlugins(product.getPlugins());
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IProductPlugin[] plugins = PluginSection.filterToArray(Stream.of(objects), IProductPlugin.class);
        this.getProduct().addPlugins(plugins);
    }

    @Override
    void removeElements(IProduct product, List<Object> elements) {
        IProductPlugin[] plugins = PluginSection.filterToArray(elements.stream(), IProductPlugin.class);
        this.getProduct().removePlugins(plugins);
    }

    static void handleAdd(AbstractProductContentSection<?> section) {
        PluginSelectionDialog pluginSelectionDialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), PluginSection.getBundles(section.getProduct()), true);
        if (pluginSelectionDialog.open() == 0) {
            Object[] result;
            Object[] objectArray = result = pluginSelectionDialog.getResult();
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IPluginModelBase pluginModelBase = (IPluginModelBase)object;
                PluginSection.addPlugin(pluginModelBase.getPluginBase().getId(), "0.0.0", section);
                ++n2;
            }
        }
    }

    private static IPluginModelBase[] getBundles(IProduct product) {
        BundleDescription[] bundles;
        ArrayList<IPluginModelBase> pluginModelBaseList = new ArrayList<IPluginModelBase>();
        BundleDescription[] bundleDescriptionArray = bundles = TargetPlatformHelper.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel;
            BundleDescription bundleDescription = bundleDescriptionArray[n2];
            if (!product.containsPlugin(bundleDescription.getSymbolicName()) && (pluginModel = PluginRegistry.findModel((BundleDescription)bundleDescription)) != null) {
                pluginModelBaseList.add(pluginModel);
            }
            ++n2;
        }
        return pluginModelBaseList.toArray(new IPluginModelBase[pluginModelBaseList.size()]);
    }

    private static void addPlugin(String id, String version, AbstractProductContentSection<?> section) {
        IProduct product = section.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IProductPlugin plugin = factory.createPlugin();
        plugin.setId(id);
        plugin.setVersion(version);
        product.addPlugins(new IProductPlugin[]{plugin});
        section.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)plugin));
    }

    /*
     * WARNING - void declaration
     */
    private IPluginModelBase findModel(IAdaptable object) {
        IAdaptable iAdaptable;
        IAdaptable iAdaptable2 = object;
        if (iAdaptable2 instanceof IJavaProject) {
            void javaProject;
            IJavaProject iJavaProject = (IJavaProject)iAdaptable2;
            IJavaProject cfr_ignored_0 = (IJavaProject)iAdaptable2;
            object = javaProject.getProject();
        }
        if ((iAdaptable = object) instanceof IProject) {
            void project;
            IProject iProject = (IProject)iAdaptable;
            IProject cfr_ignored_1 = (IProject)iAdaptable;
            return PluginRegistry.findModel((IProject)project);
        }
        IAdaptable iAdaptable3 = object;
        if (iAdaptable3 instanceof PersistablePluginObject) {
            void pluginObject;
            PersistablePluginObject persistablePluginObject = (PersistablePluginObject)iAdaptable3;
            PersistablePluginObject cfr_ignored_2 = (PersistablePluginObject)iAdaptable3;
            return PluginRegistry.findModel((String)pluginObject.getPluginID());
        }
        return null;
    }

    @Override
    void updateButtons(boolean updateRemove, boolean updateRemoveAll) {
        this.updateRemoveButtons(updateRemove ? BTN_REMOVE : -1, updateRemoveAll ? BTN_REMOVE_ALL : -1);
        EditableTablePart tablePart = this.getTablePart();
        Table table = this.getTable();
        tablePart.setButtonEnabled(BTN_PROPS, this.isEditable() && table.getSelection().length == 1);
        tablePart.setButtonEnabled(BTN_ADD_REQUIRED, this.isEditable() && table.getItemCount() > 0);
    }

    public boolean includeOptionalDependencies() {
        return this.fIncludeOptionalButton.getSelection();
    }
}

