/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.AnnotationAccess;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.EMFDocumentResourceMediator;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.XMLConfiguration;
import org.eclipse.e4.tools.emf.ui.internal.common.xml.XMLPartitionScanner;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XmiTab
extends Composite {
    private static final String ORG_ECLIPSE_E4_TOOLS_MODELEDITOR_FILTEREDTREE_ENABLED_XMITAB_DISABLED = "org.eclipse.e4.tools.modeleditor.filteredtree.enabled.xmitab.disabled";
    private static final int VERTICAL_RULER_WIDTH = 20;
    @Inject
    private IEclipseContext context;
    @Optional
    @Inject
    private IProject project;
    @Inject
    private EMFDocumentResourceMediator emfDocumentProvider;
    @Inject
    private IResourcePool resourcePool;
    @Inject
    private IEclipsePreferences preferences;
    @Inject
    @Translation
    protected Messages Messages;
    private Text text;
    protected int offsetStart;
    private SourceViewer sourceViewer;

    @Inject
    public XmiTab(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
    }

    @PostConstruct
    protected void postConstruct() {
        this.text = new Text((Composite)this, 18436);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.setMessage(this.Messages.XmiTab_TypeTextToSearch);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 13) {
                    XmiTab.this.offsetStart = 0;
                }
                XmiTab.this.offsetStart = XmiTab.this.searchAndHighlight(XmiTab.this.text.getText(), XmiTab.this.offsetStart);
            }
        });
        AnnotationModel model = new AnnotationModel();
        VerticalRuler verticalRuler = new VerticalRuler(20, (IAnnotationAccess)new AnnotationAccess(this.resourcePool));
        this.sourceViewer = new SourceViewer((Composite)this, (IVerticalRuler)verticalRuler, 68354);
        this.sourceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.sourceViewer.configure((SourceViewerConfiguration)new XMLConfiguration(this.resourcePool));
        this.sourceViewer.setEditable(this.project != null);
        this.sourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Document document = this.emfDocumentProvider.getDocument();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        this.sourceViewer.setDocument((IDocument)document);
        verticalRuler.setModel((IAnnotationModel)model);
        this.emfDocumentProvider.setValidationChangedCallback(() -> this.lambda$0(model, (IDocument)document));
        String property = System.getProperty(ORG_ECLIPSE_E4_TOOLS_MODELEDITOR_FILTEREDTREE_ENABLED_XMITAB_DISABLED);
        if (property != null || this.preferences.getBoolean("tab-form-search-show", false)) {
            this.sourceViewer.setEditable(false);
            this.sourceViewer.getTextWidget().setEnabled(false);
        }
    }

    protected int searchAndHighlight(String text, int startOffset) {
        try {
            IRegion region = this.emfDocumentProvider.findText(text, startOffset);
            if (region == null && startOffset > 0) {
                region = this.emfDocumentProvider.findText(text, 0);
            }
            if (region != null) {
                this.sourceViewer.setSelection((ISelection)new TextSelection(region.getOffset(), region.getLength()), true);
                return region.getOffset() + region.getLength();
            }
            this.sourceViewer.setSelection((ISelection)new TextSelection(0, 0), true);
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public void gotoEObject(EObject object) {
        IRegion region = this.emfDocumentProvider.findStartTag(object);
        if (region != null) {
            this.sourceViewer.setSelection((ISelection)new TextSelection(region.getOffset(), region.getLength()), true);
        } else {
            this.sourceViewer.setSelection((ISelection)new TextSelection(0, 0), true);
        }
    }

    public void paste() {
        if (this.isFilterTextFocused()) {
            this.text.paste();
        } else {
            this.sourceViewer.getTextWidget().paste();
        }
    }

    public void copy() {
        if (this.isFilterTextFocused()) {
            this.text.copy();
        } else {
            this.sourceViewer.getTextWidget().copy();
        }
    }

    public void cut() {
        if (this.isFilterTextFocused()) {
            this.text.cut();
        } else {
            this.sourceViewer.getTextWidget().cut();
        }
    }

    private boolean isFilterTextFocused() {
        return this.text.isFocusControl();
    }

    private /* synthetic */ void lambda$0(AnnotationModel annotationModel, IDocument iDocument) {
        annotationModel.removeAllAnnotations();
        for (Resource.Diagnostic d : this.emfDocumentProvider.getErrorList()) {
            Annotation a = new Annotation("e4xmi.error", false, d.getMessage());
            try {
                int l = iDocument.getLineOffset(d.getLine() - 1);
                annotationModel.addAnnotation(a, new Position(l));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

