/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeVariableMaplet;

public final class TypeVariableUtil {
    public static TypeVariableMaplet[] composeMappings(TypeVariableMaplet[] first, TypeVariableMaplet[] second) {
        Assert.isNotNull((Object)first);
        Assert.isNotNull((Object)second);
        if (first.length == 0) {
            return first;
        }
        if (second.length == 0) {
            return second;
        }
        TypeVariableMaplet source = null;
        TypeVariableMaplet target = null;
        HashSet<TypeVariableMaplet> set = new HashSet<TypeVariableMaplet>(first.length * second.length);
        int index = 0;
        while (index < first.length) {
            int offset = 0;
            while (offset < second.length) {
                source = first[index];
                target = second[offset];
                if (source.getTargetIndex() == target.getSourceIndex() && source.getTargetName().equals(target.getSourceName())) {
                    set.add(new TypeVariableMaplet(source.getSourceName(), index, target.getTargetName(), offset));
                }
                ++offset;
            }
            ++index;
        }
        TypeVariableMaplet[] mapping = new TypeVariableMaplet[set.size()];
        set.toArray(mapping);
        return mapping;
    }

    private static void extractTypeVariables(String signature, Set<String> variables) {
        Assert.isNotNull((Object)signature);
        Assert.isNotNull(variables);
        String[] arguments = Signature.getTypeArguments((String)signature);
        if (arguments.length == 0) {
            variables.add(Signature.toString((String)signature));
        } else {
            String[] stringArray = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                variables.add(Signature.toString((String)argument));
                ++n2;
            }
        }
    }

    private static String[] getReferencedVariables(IType declaring, IMember member) throws JavaModelException {
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)member);
        String[] variables = TypeVariableUtil.parametersToVariables(declaring.getTypeParameters());
        String[] result = new String[]{};
        if (member instanceof IField) {
            String signature = ((IField)member).getTypeSignature();
            String[] signatures = TypeVariableUtil.getVariableSignatures(signature);
            if (signatures.length == 0) {
                String variable = Signature.toString((String)signature);
                String[] stringArray = variables;
                int n = variables.length;
                var8_15 = 0;
                while (var8_15 < n) {
                    String v = stringArray[var8_15];
                    if (variable.equals(v)) {
                        result = new String[]{variable};
                        break;
                    }
                    ++var8_15;
                }
            } else {
                result = new String[signatures.length];
                int index = 0;
                while (index < result.length) {
                    result[index] = Signature.toString((String)signatures[index]);
                    ++index;
                }
            }
        } else if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = method.getParameterTypes();
            var8_15 = stringArray.length;
            int n = 0;
            while (n < var8_15) {
                String type = stringArray[n];
                TypeVariableUtil.extractTypeVariables(type, set);
                ++n;
            }
            TypeVariableUtil.extractTypeVariables(method.getReturnType(), set);
            String[] arguments = TypeVariableUtil.parametersToVariables(((IMethod)member).getTypeParameters());
            Collections.addAll(set, arguments);
            result = new String[set.size()];
            set.toArray(result);
        } else if (member instanceof IType) {
            result = TypeVariableUtil.parametersToVariables(((IType)member).getTypeParameters());
        } else {
            JavaManipulationPlugin.logErrorMessage("Unexpected sub-type of IMember: " + member.getClass().getName());
            Assert.isTrue((boolean)false);
        }
        ArrayList<String> list = new ArrayList<String>(variables.length);
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            String[] stringArray2 = result;
            int n3 = result.length;
            int n4 = 0;
            while (n4 < n3) {
                String r = stringArray2[n4];
                if (variable.equals(r)) {
                    list.add(r);
                }
                ++n4;
            }
            ++n2;
        }
        result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String[] getUnmappedVariables(TypeVariableMaplet[] mapping, IType declaring, IMember member) throws JavaModelException {
        Assert.isNotNull((Object)mapping);
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)member);
        ArrayList<String> list = null;
        String[] types = TypeVariableUtil.getReferencedVariables(declaring, member);
        if (mapping.length == 0) {
            list = new ArrayList<String>(types.length);
            list.addAll(Arrays.asList(types));
        } else {
            String type;
            HashSet<String> mapped = new HashSet<String>(types.length);
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                type = stringArray[n2];
                TypeVariableMaplet[] typeVariableMapletArray = mapping;
                int n3 = mapping.length;
                int n4 = 0;
                while (n4 < n3) {
                    TypeVariableMaplet m = typeVariableMapletArray[n4];
                    if (m.getSourceName().equals(type)) {
                        mapped.add(type);
                    }
                    ++n4;
                }
                ++n2;
            }
            list = new ArrayList(types.length - mapped.size());
            stringArray = types;
            n = types.length;
            n2 = 0;
            while (n2 < n) {
                type = stringArray[n2];
                if (!mapped.contains(type)) {
                    list.add(type);
                }
                ++n2;
            }
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private static String[] getVariableSignatures(String signature) {
        Assert.isNotNull((Object)signature);
        String[] result = null;
        try {
            result = Signature.getTypeArguments((String)signature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = new String[]{};
        }
        return result;
    }

    public static TypeVariableMaplet[] inverseMapping(TypeVariableMaplet[] mapping) {
        Assert.isNotNull((Object)mapping);
        TypeVariableMaplet[] result = new TypeVariableMaplet[mapping.length];
        TypeVariableMaplet maplet = null;
        int index = 0;
        while (index < mapping.length) {
            maplet = mapping[index];
            result[index] = new TypeVariableMaplet(maplet.getTargetName(), maplet.getTargetIndex(), maplet.getSourceName(), maplet.getSourceIndex());
            ++index;
        }
        return result;
    }

    private static TypeVariableMaplet[] parametersToSignatures(ITypeParameter[] domain, String[] range, boolean indexes) {
        Assert.isNotNull((Object)domain);
        Assert.isNotNull((Object)range);
        HashSet<TypeVariableMaplet> set = new HashSet<TypeVariableMaplet>();
        ITypeParameter source = null;
        String target = null;
        String element = null;
        String signature = null;
        int index = 0;
        while (index < domain.length) {
            source = domain[index];
            int offset = 0;
            while (offset < range.length) {
                target = range[offset];
                element = source.getElementName();
                signature = Signature.toString((String)target);
                if (indexes) {
                    if (offset == index) {
                        set.add(new TypeVariableMaplet(element, index, signature, offset));
                    }
                } else if (element.equals(signature)) {
                    set.add(new TypeVariableMaplet(element, index, signature, offset));
                }
                ++offset;
            }
            ++index;
        }
        TypeVariableMaplet[] result = new TypeVariableMaplet[set.size()];
        set.toArray(result);
        return result;
    }

    private static String[] parametersToVariables(ITypeParameter[] parameters) {
        Assert.isNotNull((Object)parameters);
        String[] result = new String[parameters.length];
        int index = 0;
        while (index < parameters.length) {
            result[index] = parameters[index].getElementName();
            ++index;
        }
        return result;
    }

    private static TypeVariableMaplet[] signaturesToParameters(String[] domain, ITypeParameter[] range) {
        Assert.isNotNull((Object)domain);
        Assert.isNotNull((Object)range);
        Assert.isTrue((domain.length == 0 || domain.length == range.length ? 1 : 0) != 0);
        ArrayList<TypeVariableMaplet> list = new ArrayList<TypeVariableMaplet>();
        String source = null;
        String target = null;
        int index = 0;
        while (index < domain.length) {
            source = Signature.toString((String)domain[index]);
            target = range[index].getElementName();
            list.add(new TypeVariableMaplet(source, index, target, index));
            ++index;
        }
        TypeVariableMaplet[] result = new TypeVariableMaplet[list.size()];
        list.toArray(result);
        return result;
    }

    public static TypeVariableMaplet[] subTypeToInheritedType(IType type) throws JavaModelException {
        String[] range;
        String signature;
        Assert.isNotNull((Object)type);
        ITypeParameter[] domain = type.getTypeParameters();
        if (domain.length > 0 && (signature = type.getSuperclassTypeSignature()) != null && (range = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(domain, range, false);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] subTypeToSuperType(IType subtype, IType supertype) throws JavaModelException {
        String[] domain;
        String signature;
        ITypeParameter[] range;
        Assert.isNotNull((Object)subtype);
        Assert.isNotNull((Object)supertype);
        TypeVariableMaplet[] mapping = TypeVariableUtil.subTypeToInheritedType(subtype);
        if (mapping.length > 0 && (range = supertype.getTypeParameters()).length > 0 && (signature = subtype.getSuperclassTypeSignature()) != null && (domain = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.composeMappings(mapping, TypeVariableUtil.signaturesToParameters(domain, range));
        }
        return mapping;
    }

    public static TypeVariableMaplet[] superTypeToInheritedType(IType supertype, IType subtype) throws JavaModelException {
        String[] range;
        String signature;
        Assert.isNotNull((Object)subtype);
        Assert.isNotNull((Object)supertype);
        ITypeParameter[] domain = supertype.getTypeParameters();
        if (domain.length > 0 && (signature = subtype.getSuperclassTypeSignature()) != null && (range = TypeVariableUtil.getVariableSignatures(signature)).length > 0) {
            return TypeVariableUtil.parametersToSignatures(domain, range, true);
        }
        return new TypeVariableMaplet[0];
    }

    public static TypeVariableMaplet[] superTypeToSubType(IType supertype, IType subtype) throws JavaModelException {
        Assert.isNotNull((Object)supertype);
        Assert.isNotNull((Object)subtype);
        return TypeVariableUtil.inverseMapping(TypeVariableUtil.subTypeToSuperType(subtype, supertype));
    }

    private TypeVariableUtil() {
    }
}

