/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.Utils;

public class FetchFileGenerator
extends AbstractScriptGenerator {
    private static final String ENTRY_SEPARATOR = "%";
    private static final String FILTER_SEPARATOR = "&";
    private static final String DATA_SEPARATOR = "|";
    private static final String UNKNOWN = "*";
    private String[] filters;
    private String mapLocation;
    private String collectedFiles;
    private String[] componentFilter;
    private Properties mapContent;

    private void displayDebugInfo() {
        if (!BundleHelper.getDefault().isDebugging()) {
            return;
        }
        System.out.println("Filters: " + (this.filters != null ? Utils.getStringFromArray(this.filters, ", ") : "NONE"));
        System.out.println("Component filter: " + (this.componentFilter != null ? Utils.getStringFromArray(this.componentFilter, ", ") : "NONE"));
        System.out.println("Map location: " + this.mapLocation);
    }

    @Override
    public void generate() throws CoreException {
        this.collectedFiles = "";
        this.displayDebugInfo();
        this.openScript(workingDirectory, "fetch.xml");
        this.generatePrologue();
        try {
            this.processMapFile();
            this.writeDirectory();
            this.generateEpilogue();
        }
        finally {
            this.closeScript();
        }
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Packager' File fetcher", "main", ".");
        this.script.println();
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateEpilogue() {
        this.script.printTargetEnd();
        this.script.printProjectEnd();
        this.script.close();
    }

    public void generateFetchFileFor(String fileName, String baseurl, String loginInfo) {
        String login = null;
        String password = null;
        String[] login_password = Utils.getArrayFromString(loginInfo, ":");
        if (login_password.length == 2) {
            login = login_password[0];
            password = login_password[1];
        } else {
            Status status = new Status(2, "org.eclipse.pde.build", 1, NLS.bind((String)Messages.warning_missingPassword, (Object)fileName), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
        }
        this.script.printGet(baseurl + fileName, Utils.getPropertyFormat("downloadDirectory") + "/" + fileName, login, password, true);
    }

    public void setContentFilter(String filters) {
        this.filters = Utils.getArrayFromStringWithBlank(filters, ",");
    }

    public void setMapLocation(String mapLocation) {
        this.mapLocation = mapLocation;
    }

    private void writeDirectory() throws CoreException {
        Properties selectedFiles = new Properties();
        selectedFiles.put("toUnzip", this.collectedFiles);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(workingDirectory + "/packager.directory.txt"));){
                selectedFiles.store(stream, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String message = NLS.bind((String)Messages.exception_writingFile, (Object)(workingDirectory + "/packager.directory.txt"));
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
    }

    private void processMapFile() throws CoreException {
        this.mapContent = FetchFileGenerator.readProperties(this.mapLocation, "", 4);
        for (Map.Entry<Object, Object> mapEntry : this.mapContent.entrySet()) {
            String fileName = (String)mapEntry.getKey();
            String[] fileDescription = Utils.getArrayFromStringWithBlank((String)mapEntry.getValue(), DATA_SEPARATOR);
            if (fileDescription.length < 4) {
                String message = NLS.bind((String)Messages.error_incorrectDirectoryEntry, (Object)((String)mapEntry.getKey() + "=" + (String)mapEntry.getValue()));
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 9, message, null));
            }
            String userInfos = "";
            try {
                userInfos = new URL(fileDescription[0]).getUserInfo();
            }
            catch (MalformedURLException e) {
                Status status = new Status(4, "org.eclipse.pde.build", 3, NLS.bind((String)Messages.exception_url, (Object)fileDescription[0]), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            if (this.filterByConfig(fileDescription[1]) && this.filterByFilter(fileDescription[3]) && this.filterByComponentName(fileDescription.length > 4 ? fileDescription[4] : UNKNOWN)) {
                this.generateFetchFileFor(fileName, fileDescription[0], userInfos);
                this.collectedFiles = String.valueOf(this.collectedFiles) + fileName + DATA_SEPARATOR + (fileDescription[2].equals("") ? "." : fileDescription[2]) + DATA_SEPARATOR + fileDescription[1] + ENTRY_SEPARATOR;
                continue;
            }
            if (!BundleHelper.getDefault().isDebugging()) continue;
            Status status = new Status(1, "org.eclipse.pde.build", 21, NLS.bind((String)Messages.error_fetchingFailed, (Object)fileDescription[2]), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
        }
    }

    private boolean filterByFilter(String filterString) {
        if (this.filters.length == 0) {
            return true;
        }
        String[] entryFilters = Utils.getArrayFromStringWithBlank(filterString, ",");
        if (entryFilters.length == 0) {
            return true;
        }
        String[] stringArray = entryFilters;
        int n = entryFilters.length;
        int n2 = 0;
        while (n2 < n) {
            String entryFilter = stringArray[n2];
            String[] stringArray2 = this.filters;
            int n3 = this.filters.length;
            int n4 = 0;
            while (n4 < n3) {
                String filter = stringArray2[n4];
                if (filter.equals(entryFilter)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private boolean filterByConfig(String entryConfigString) {
        String[] entryConfigs = Utils.getArrayFromStringWithBlank(entryConfigString, FILTER_SEPARATOR);
        if (entryConfigs.length == 0 || this.containsGenericConfig(FetchFileGenerator.getConfigInfos())) {
            return true;
        }
        String[] stringArray = entryConfigs;
        int n = entryConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            String entryConfig = stringArray[n2];
            Iterator<Config> iter = FetchFileGenerator.getConfigInfos().iterator();
            Config aConfig = new Config(entryConfig);
            while (iter.hasNext()) {
                if (!aConfig.equals(iter.next()) && !aConfig.equals(Config.genericConfig())) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean containsGenericConfig(List<Config> configs) {
        if (configs == null) {
            return false;
        }
        Iterator<Config> iter = configs.iterator();
        while (iter.hasNext()) {
            if (!Config.genericConfig().equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean filterByComponentName(String componentName) {
        if (componentName.equals(UNKNOWN) || this.componentFilter == null) {
            return true;
        }
        String[] stringArray = this.componentFilter;
        int n = this.componentFilter.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.equalsIgnoreCase(componentName) || element.equalsIgnoreCase(UNKNOWN)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setComponentFilter(String componentFiler) {
        this.componentFilter = Utils.getArrayFromStringWithBlank(componentFiler, ",");
    }
}

