/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.BoundForEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IEventFig;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class DisplayEvent {
    private static final int EVENT_SELECTION_DELTA = 8;
    private EditPart editpart;

    public DisplayEvent(EditPart editpart) {
        this.editpart = editpart;
    }

    public MessageOccurrenceSpecification getMessageEvent(IFigure container, Point locationOntheScreen) {
        Point LocationAbsolute = locationOntheScreen.getCopy();
        IFigure editPartFigure = ((GraphicalEditPart)this.editpart).getFigure();
        editPartFigure.getParent().translateToRelative((Translatable)LocationAbsolute);
        Rectangle recLoacal = new Rectangle(50, 200, 100, 100);
        IFigure fig = editPartFigure;
        Point ptOnscreen = recLoacal.getTopLeft().translate(fig.getBounds().getTopLeft());
        fig.getParent().translateToAbsolute((Translatable)ptOnscreen);
        Node node = (Node)this.editpart.getModel();
        EList sourceEdge = node.getSourceEdges();
        for (Edge edge : sourceEdge) {
            MessageOccurrenceSpecification m = this.getMessageEvent((NodeEditPart)this.editpart, node, edge, LocationAbsolute);
            if (m == null) continue;
            return m;
        }
        EList targetEdge = node.getTargetEdges();
        for (Edge edge : targetEdge) {
            MessageOccurrenceSpecification m = this.getMessageEvent((NodeEditPart)this.editpart, node, edge, LocationAbsolute);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public OccurrenceSpecification getActionExecutionSpecificationEvent(IFigure container, Point locationOntheScreen) {
        Point LocationAbsolute = locationOntheScreen.getCopy();
        IFigure editPartFigure = ((GraphicalEditPart)this.editpart).getFigure();
        editPartFigure.getParent().translateToRelative((Translatable)LocationAbsolute);
        Rectangle recLoacal = new Rectangle(50, 200, 100, 100);
        IFigure fig = editPartFigure;
        Point ptOnscreen = recLoacal.getTopLeft().translate(fig.getBounds().getTopLeft());
        fig.getParent().translateToAbsolute((Translatable)ptOnscreen);
        Node node = (Node)this.editpart.getModel();
        for (Object part : this.editpart.getChildren()) {
            OccurrenceSpecification occurrenceSpecification;
            if (!(part instanceof AbstractExecutionSpecificationEditPart) || (occurrenceSpecification = this.getEventFromExecutionSpecification((NodeEditPart)this.editpart, (AbstractExecutionSpecificationEditPart)((Object)part), LocationAbsolute)) == null) continue;
            return occurrenceSpecification;
        }
        return null;
    }

    public Point getRealEventLocation(Point location) {
        Point realLocationEvent = this.getRealEventLocationFromExecutionSpecification(location.getCopy());
        if (location.equals((Object)realLocationEvent)) {
            realLocationEvent = this.getRealEventLocationFromMessage(location.getCopy());
        }
        realLocationEvent = SequenceUtil.getSnappedLocation(this.editpart, realLocationEvent).getCopy();
        return realLocationEvent;
    }

    public Point getRealEventLocationFromExecutionSpecification(Point location) {
        Point relativeLocation = location.getCopy();
        IFigure editPartFigure = ((GraphicalEditPart)this.editpart).getFigure();
        editPartFigure.getParent().translateToRelative((Translatable)relativeLocation);
        Point eventLocation = relativeLocation.getCopy();
        for (Object part : this.editpart.getChildren()) {
            if (!(part instanceof AbstractExecutionSpecificationEditPart)) continue;
            AbstractExecutionSpecificationEditPart esEditPart = (AbstractExecutionSpecificationEditPart)((Object)part);
            int y = ((Bounds)((Node)esEditPart.getNotationView()).getLayoutConstraint()).getY();
            int height = ((Bounds)((Node)esEditPart.getNotationView()).getLayoutConstraint()).getHeight();
            int startY = y;
            int finishY = y + height;
            if (eventLocation.equals((Object)relativeLocation)) {
                eventLocation = this.getNewEventLocationY(relativeLocation, editPartFigure.getBounds().y + startY, editPartFigure);
            }
            if (!eventLocation.equals((Object)relativeLocation)) continue;
            eventLocation = this.getNewEventLocationY(relativeLocation, editPartFigure.getBounds().y + finishY, editPartFigure);
        }
        editPartFigure.getParent().translateToAbsolute((Translatable)eventLocation);
        return eventLocation;
    }

    private Point getNewEventLocationY(Point relativeMouseLocation, int referenceY, IFigure editPartFigure) {
        Point newPoint = new Point(relativeMouseLocation);
        if (referenceY - 8 < relativeMouseLocation.y() && relativeMouseLocation.y() < referenceY + 8) {
            newPoint.setY(referenceY);
            newPoint.setX(relativeMouseLocation.x());
        }
        return newPoint;
    }

    public Point getRealEventLocationFromMessage(Point location) {
        PrecisionPoint relativeLocation = SequenceUtil.getSnappedLocation(this.editpart, location);
        IFigure editPartFigure = ((GraphicalEditPart)this.editpart).getFigure();
        editPartFigure.getParent().translateToRelative((Translatable)relativeLocation);
        Point eventLocation = relativeLocation.getCopy();
        Node node = (Node)this.editpart.getModel();
        EList sourceEdge = node.getSourceEdges();
        for (Edge edge : sourceEdge) {
            IdentityAnchor anchor = (IdentityAnchor)edge.getSourceAnchor();
            int y = this.getYfromAnchor(node, anchor);
            if (!eventLocation.equals((Object)relativeLocation)) continue;
            eventLocation = this.getNewEventLocationY((Point)relativeLocation, editPartFigure.getBounds().y + y, editPartFigure);
        }
        EList targetEdges = node.getTargetEdges();
        for (Edge edge : targetEdges) {
            IdentityAnchor anchor = (IdentityAnchor)edge.getTargetAnchor();
            if (anchor == null) continue;
            int y = this.getYfromAnchor(node, anchor);
            if (!eventLocation.equals((Object)relativeLocation)) continue;
            eventLocation = this.getNewEventLocationY((Point)relativeLocation, editPartFigure.getBounds().y + y, editPartFigure);
        }
        editPartFigure.getParent().translateToAbsolute((Translatable)eventLocation);
        return eventLocation;
    }

    public int getYfromAnchor(Node node, IdentityAnchor anchor) {
        PrecisionPoint point = BaseSlidableAnchor.parseTerminalString((String)anchor.getId());
        if (point == null) {
            return 0;
        }
        double yPercent = point.preciseY();
        int height = BoundForEditPart.getHeightFromView(node);
        int y = (int)(yPercent * (double)height);
        return y;
    }

    protected OccurrenceSpecification getEventFromExecutionSpecification(NodeEditPart lifelineEditPart, AbstractExecutionSpecificationEditPart executionSpecEditPart, Point locationAbsolute) {
        Node executionNode = (Node)executionSpecEditPart.getNotationView();
        ExecutionSpecification executionSpecification = (ExecutionSpecification)executionSpecEditPart.resolveSemanticElement();
        IFigure lifelineFigure = lifelineEditPart.getFigure();
        double y = ((Bounds)executionNode.getLayoutConstraint()).getY();
        if (lifelineFigure.getBounds().y + (int)y - 8 < locationAbsolute.y() && locationAbsolute.y() < lifelineFigure.getBounds().y + (int)y + 8) {
            return executionSpecification.getStart();
        }
        y = ((Bounds)executionNode.getLayoutConstraint()).getY() + BoundForEditPart.getHeightFromView(executionNode);
        if (lifelineFigure.getBounds().y + (int)y - 8 < locationAbsolute.y() && locationAbsolute.y() < lifelineFigure.getBounds().y + (int)y + 8) {
            return executionSpecification.getFinish();
        }
        return null;
    }

    protected MessageOccurrenceSpecification getMessageEvent(NodeEditPart container, Node node, Edge edge, Point currentPosition) {
        IdentityAnchor anchor = null;
        anchor = edge.getSource().equals(node) ? (IdentityAnchor)edge.getSourceAnchor() : (IdentityAnchor)edge.getTargetAnchor();
        double posY = this.getYfromAnchor(node, anchor);
        IFigure lifelineFigure = ((GraphicalEditPart)this.editpart).getFigure();
        if (lifelineFigure.getBounds().y + (int)posY - 8 < currentPosition.y() && currentPosition.y() < lifelineFigure.getBounds().y + (int)posY + 8 && edge.getElement() instanceof Message) {
            if (anchor == (IdentityAnchor)edge.getSourceAnchor()) {
                return (MessageOccurrenceSpecification)((Message)edge.getElement()).getSendEvent();
            }
            return (MessageOccurrenceSpecification)((Message)edge.getElement()).getReceiveEvent();
        }
        return null;
    }

    public void addFigureEvent(IFigure container, Point locationOntheScreen) {
        Point LocationAbsolute = locationOntheScreen.getCopy();
        IFigure editPartFigure = ((GraphicalEditPart)this.editpart).getFigure();
        editPartFigure.getParent().translateToRelative((Translatable)LocationAbsolute);
        Rectangle recLoacal = new Rectangle(50, 200, 100, 100);
        IFigure fig = editPartFigure;
        Point ptOnscreen = recLoacal.getTopLeft().translate(fig.getBounds().getTopLeft());
        fig.getParent().translateToAbsolute((Translatable)ptOnscreen);
        Node node = (Node)this.editpart.getModel();
        EList sourceEdge = node.getSourceEdges();
        for (Edge edge : sourceEdge) {
            this.displayEventFromMessages((NodeEditPart)this.editpart, node, edge, LocationAbsolute);
        }
        EList targetEdge = node.getTargetEdges();
        for (Edge edge : targetEdge) {
            this.displayEventFromMessages((NodeEditPart)this.editpart, node, edge, LocationAbsolute);
        }
        for (Object part : this.editpart.getChildren()) {
            if (!(part instanceof AbstractExecutionSpecificationEditPart)) continue;
            this.displayEventFromExecutionSpecification((NodeEditPart)this.editpart, (AbstractExecutionSpecificationEditPart)((Object)part), LocationAbsolute);
        }
    }

    protected void displayEventFromExecutionSpecification(NodeEditPart lifelineEditPart, AbstractExecutionSpecificationEditPart executionSpecEditPart, Point locationAbsolute) {
        Node executionNode = (Node)executionSpecEditPart.getNotationView();
        double posY = ((Bounds)executionNode.getLayoutConstraint()).getY();
        this.addAnEvent(lifelineEditPart.getFigure(), posY, ColorConstants.white, locationAbsolute);
        posY = ((Bounds)executionNode.getLayoutConstraint()).getY() + BoundForEditPart.getHeightFromView(executionNode);
        this.addAnEvent(lifelineEditPart.getFigure(), posY, ColorConstants.white, locationAbsolute);
    }

    protected void displayEventFromMessages(NodeEditPart container, Node node, Edge edge, Point currentPosition) {
        IdentityAnchor anchor = null;
        anchor = edge.getSource().equals(node) ? (IdentityAnchor)edge.getSourceAnchor() : (IdentityAnchor)edge.getTargetAnchor();
        if (anchor != null) {
            double posY = this.getYfromAnchor(node, anchor);
            this.addAnEvent(container.getFigure(), posY, ColorConstants.white, currentPosition);
        }
    }

    protected void addAnEvent(IFigure container, double y, Color color, Point currentPosition) {
        EventFig ellipseFigure = new EventFig();
        IFigure lifelineFigure = ((GraphicalEditPart)this.editpart).getFigure();
        PrecisionRectangle EventBoundsOnScreen = new PrecisionRectangle((double)(lifelineFigure.getBounds().x + lifelineFigure.getBounds().width / 2 - 8), (double)(lifelineFigure.getBounds().y + (int)y - 8), 16.0, 16.0);
        if (lifelineFigure.getBounds().y + (int)y - 8 < currentPosition.y() && currentPosition.y() < lifelineFigure.getBounds().y + (int)y + 8) {
            ellipseFigure.setBackgroundColor(ColorConstants.green);
        } else {
            ellipseFigure.setBackgroundColor(color);
        }
        ellipseFigure.setLineWidth(2);
        ellipseFigure.setBounds((Rectangle)EventBoundsOnScreen);
        container.add((IFigure)ellipseFigure);
    }

    public void removeFigureEvent(IFigure container) {
        ArrayList<IFigure> eventFigureList = new ArrayList<IFigure>();
        for (Object iFigure : container.getChildren()) {
            if (!(iFigure instanceof IEventFig)) continue;
            eventFigureList.add((IFigure)iFigure);
        }
        for (IFigure iFigure : eventFigureList) {
            container.remove(iFigure);
        }
    }

    public class EventFig
    extends Ellipse
    implements IEventFig {
    }
}

