/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Messages;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class DropinsRepositoryListener
extends RepositoryListener {
    private static final String PREFIX = "[reconciler] [dropins] ";
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private static final String JAR = ".jar";
    private static final String LINK = ".link";
    private static final String ZIP = ".zip";
    private static final String LINKS_PATH = "path";
    private static final String LINK_IS_OPTIONAL = "optional";
    private static final String DROPIN_ARTIFACT_REPOSITORIES = "dropin.artifactRepositories";
    private static final String DROPIN_METADATA_REPOSITORIES = "dropin.metadataRepositories";
    private static final String PIPE = "|";
    private final IProvisioningAgent agent;
    private List<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
    private List<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();

    public DropinsRepositoryListener(IProvisioningAgent agent, String repositoryName, Map<String, String> properties) {
        super(repositoryName, properties);
        this.agent = agent;
    }

    public boolean isInterested(File file) {
        return true;
    }

    public boolean added(File file) {
        if (super.added(file)) {
            if (Tracing.DEBUG_RECONCILER) {
                Tracing.debug((String)("[reconciler] [dropins] Interesting feature or bundle added: " + String.valueOf(file)));
            }
            return true;
        }
        this.addRepository(file);
        return true;
    }

    public boolean changed(File file) {
        if (super.changed(file)) {
            if (Tracing.DEBUG_RECONCILER) {
                Tracing.debug((String)("[reconciler] [dropins] Interesting feature or bundle changed: " + String.valueOf(file)));
            }
            return true;
        }
        this.addRepository(file);
        return true;
    }

    private void addRepository(File file) {
        URI linkLocation;
        URI repoLocation = this.createRepositoryLocation(file);
        if (repoLocation == null) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (file.isFile() && file.getName().endsWith(LINK) && (linkLocation = this.getLinkRepository(file, false)) != null) {
            properties.put("org.eclipse.update.site.linkFile", file.getAbsolutePath());
        }
        this.getMetadataRepository(repoLocation, properties);
        this.getArtifactRepository(repoLocation, properties);
    }

    static LinkedRepository getLinkedRepository(File file) {
        File root;
        Properties links = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                links.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.error_reading_link, (Object)file.getAbsolutePath()), (Throwable)e));
            return null;
        }
        String path = links.getProperty(LINKS_PATH);
        if (path == null) {
            return null;
        }
        path = path.startsWith("r ") ? path.substring(2).trim() : (path.startsWith("rw ") ? path.substring(3).trim() : path.trim());
        File linkedFile = new File(path = Activator.substituteVariables(path));
        if (!linkedFile.isAbsolute() && (root = Activator.getEclipseHome()) != null) {
            linkedFile = new File(root, path);
        }
        try {
            LinkedRepository result = new LinkedRepository(linkedFile.getCanonicalFile());
            String optional = links.getProperty(LINK_IS_OPTIONAL);
            result.setOptional(Boolean.parseBoolean(optional));
            return result;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", NLS.bind((String)Messages.error_resolving_link, (Object)linkedFile.getAbsolutePath(), (Object)file.getAbsolutePath()), (Throwable)e));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URI createRepositoryLocation(File file) {
        try {
            file = file.getCanonicalFile();
            String fileName = file.getName();
            if (fileName.endsWith(LINK)) {
                return this.getLinkRepository(file, true);
            }
            if (!file.isDirectory()) {
                if (fileName.endsWith(ZIP)) return new URI("jar:" + String.valueOf(file.toURI()) + "!/");
                if (!fileName.endsWith(JAR)) return this.getLinkRepository(file, false);
                return new URI("jar:" + String.valueOf(file.toURI()) + "!/");
            }
            if (!file.getName().equals(PLUGINS)) {
                if (!file.getName().equals(FEATURES)) return file.toURI();
                File parentFile = file.getParentFile();
                if (parentFile == null) return null;
                if (!new File(parentFile, PLUGINS).isDirectory()) return parentFile.toURI();
                return null;
            }
            File parentFile = file.getParentFile();
            if (parentFile == null) return null;
            URI uRI = parentFile.toURI();
            return uRI;
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while building repository location from file: " + file.getAbsolutePath(), (Throwable)e));
            return null;
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while building repository location from file: " + file.getAbsolutePath(), (Throwable)e));
        }
        return null;
    }

    private URI getLinkRepository(File file, boolean logMissingLink) {
        LinkedRepository repo = DropinsRepositoryListener.getLinkedRepository(file);
        if (repo == null) {
            if (logMissingLink) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Unable to determine link location from file: " + file.getAbsolutePath()));
            }
            return null;
        }
        return repo.isOptional() && !repo.exists() ? null : repo.getLocation().toURI();
    }

    public void getMetadataRepository(URI repoURL, Map<String, String> properties) {
        try {
            IMetadataRepository repository = null;
            try {
                ExtensionLocationMetadataRepository.validate((URI)repoURL, null);
                repository = Activator.createExtensionLocationMetadataRepository(repoURL, "dropins metadata repo: " + String.valueOf(repoURL), properties);
            }
            catch (ProvisionException provisionException) {
                repository = Activator.loadMetadataRepository(repoURL, null);
            }
            this.metadataRepositories.add(repository);
            this.debugRepository(repository);
        }
        catch (ProvisionException ex) {
            LogHelper.log((ProvisionException)ex);
        }
    }

    private void debugRepository(IMetadataRepository repository) {
        if (!Tracing.DEBUG_RECONCILER) {
            return;
        }
        Tracing.debug((String)("[reconciler] [dropins] Repository created " + String.valueOf(repository.getLocation())));
        IQueryResult result = repository.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        for (IInstallableUnit iInstallableUnit : result) {
            Tracing.debug((String)("[reconciler] [dropins] \t" + String.valueOf(iInstallableUnit)));
        }
    }

    public void getArtifactRepository(URI repoURL, Map<String, String> properties) {
        try {
            IArtifactRepository repository = null;
            try {
                ExtensionLocationArtifactRepository.validate((URI)repoURL, null);
                repository = Activator.createExtensionLocationArtifactRepository(repoURL, "dropins artifact repo: " + String.valueOf(repoURL), properties);
            }
            catch (ProvisionException provisionException) {
                repository = Activator.loadArtifactRepository(repoURL, null);
            }
            this.artifactRepositories.add(repository);
        }
        catch (ProvisionException ex) {
            LogHelper.log((ProvisionException)ex);
        }
    }

    public void stopPoll() {
        this.synchronizeDropinMetadataRepositories();
        this.synchronizeDropinArtifactRepositories();
        super.stopPoll();
    }

    private void synchronizeDropinMetadataRepositories() {
        ArrayList<String> currentRepositories = new ArrayList<String>();
        for (IMetadataRepository repository : this.metadataRepositories) {
            currentRepositories.add(repository.getLocation().toString());
        }
        List<String> previousRepositories = this.getListRepositoryProperty((IRepository<?>)this.getMetadataRepository(), DROPIN_METADATA_REPOSITORIES);
        for (String repository : previousRepositories) {
            if (currentRepositories.contains(repository)) continue;
            this.removeMetadataRepository(repository);
        }
        this.setListRepositoryProperty((IRepository<?>)this.getMetadataRepository(), DROPIN_METADATA_REPOSITORIES, (List<String>)currentRepositories);
    }

    private void removeMetadataRepository(String urlString) {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        if (manager == null) {
            throw new IllegalStateException(Messages.metadata_repo_manager_not_registered);
        }
        try {
            manager.removeRepository(new URI(urlString));
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while creating URL from: " + urlString, (Throwable)e));
        }
    }

    private void synchronizeDropinArtifactRepositories() {
        ArrayList<String> currentRepositories = new ArrayList<String>();
        for (IArtifactRepository repository : this.artifactRepositories) {
            currentRepositories.add(repository.getLocation().toString());
        }
        List<String> previousRepositories = this.getListRepositoryProperty((IRepository<?>)this.getArtifactRepository(), DROPIN_ARTIFACT_REPOSITORIES);
        for (String repository : previousRepositories) {
            if (currentRepositories.contains(repository)) continue;
            this.removeArtifactRepository(repository);
        }
        this.setListRepositoryProperty((IRepository<?>)this.getArtifactRepository(), DROPIN_ARTIFACT_REPOSITORIES, (List<String>)currentRepositories);
    }

    public void removeArtifactRepository(String urlString) {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
        if (manager == null) {
            throw new IllegalStateException(Messages.artifact_repo_manager_not_registered);
        }
        try {
            manager.removeRepository(new URI(urlString));
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.reconciler.dropins", "Error occurred while creating URL from: " + urlString, (Throwable)e));
        }
    }

    private List<String> getListRepositoryProperty(IRepository<?> repository, String key) {
        ArrayList<String> listProperty = new ArrayList<String>();
        String dropinRepositories = (String)repository.getProperties().get(key);
        if (dropinRepositories != null) {
            StringTokenizer tokenizer = new StringTokenizer(dropinRepositories, PIPE);
            while (tokenizer.hasMoreTokens()) {
                listProperty.add(tokenizer.nextToken());
            }
        }
        return listProperty;
    }

    private void setListRepositoryProperty(IRepository<?> repository, String key, List<String> listProperty) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> it = listProperty.iterator();
        while (it.hasNext()) {
            String repositoryString = it.next();
            buffer.append(repositoryString);
            if (!it.hasNext()) continue;
            buffer.append(PIPE);
        }
        String value = buffer.length() == 0 ? null : buffer.toString();
        repository.setProperty(key, value);
    }

    public Collection<IMetadataRepository> getMetadataRepositories() {
        ArrayList<IMetadataRepository> result = new ArrayList<IMetadataRepository>(this.metadataRepositories);
        result.add(this.getMetadataRepository());
        return result;
    }

    static class LinkedRepository {
        private File location;
        private boolean optional = false;

        LinkedRepository(File location) {
            if (location == null) {
                throw new IllegalArgumentException("Repository location cannot be null.");
            }
            this.location = location;
        }

        boolean exists() {
            return this.location.exists();
        }

        File getLocation() {
            return this.location;
        }

        boolean isOptional() {
            return this.optional;
        }

        void setOptional(boolean optional) {
            this.optional = optional;
        }
    }
}

