/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CanonicalState
extends ToggleState
implements ISelectionListener {
    private ISelectionService selectionService = null;
    private Reference<IGraphicalEditPart> selectedEditPart;

    public CanonicalState() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.selectionService = window.getSelectionService();
            if (this.selectionService != null) {
                this.selectionService.addSelectionListener((ISelectionListener)this);
                this.update(this.selectionService.getSelection());
            }
        }
    }

    public void dispose() {
        if (this.selectionService != null) {
            this.selectionService.removeSelectionListener((ISelectionListener)this);
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update(selection);
    }

    private void update(ISelection selection) {
        IGraphicalEditPart editPart;
        boolean state = false;
        this.selectedEditPart = null;
        if (selection instanceof IStructuredSelection && (editPart = (IGraphicalEditPart)AdapterUtils.adapt((Object)((IStructuredSelection)selection).getFirstElement(), IGraphicalEditPart.class, null)) != null) {
            this.selectedEditPart = new WeakReference<IGraphicalEditPart>(editPart);
            state = DiagramEditPartsUtil.isCanonical((EditPart)editPart);
        }
        this.setValue(state);
    }

    public Object getValue() {
        IGraphicalEditPart editPart = this.selectedEditPart == null ? null : this.selectedEditPart.get();
        return editPart != null ? Boolean.valueOf(DiagramEditPartsUtil.isCanonical((EditPart)editPart)) : super.getValue();
    }
}

