/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class Navigatable
implements INavigatable {
    public static final int NEXT_UNRESOLVED_CHANGE = 80;
    public static final int PREVIOUS_UNRESOLVED_CHANGE = 81;
    private final WrappableTreeViewer viewer;
    private final EMFCompareStructureMergeViewerContentProvider contentProvider;
    protected EMFCompareStructureMergeViewerContentProvider.CallbackType uiSyncCallbackType = EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC;
    private TreeVisitor treeVisitor;
    private final Map<Object, Object[]> allChildren = Maps.newHashMap();
    private final Map<Object, Object> allAncestors = Maps.newHashMap();

    public Navigatable(WrappableTreeViewer viewer, EMFCompareStructureMergeViewerContentProvider contentProvider) {
        this.viewer = viewer;
        this.contentProvider = contentProvider;
    }

    public boolean selectChange(final int flag) {
        this.contentProvider.runWhenReady(this.uiSyncCallbackType, new Runnable(){

            @Override
            public void run() {
                Object firstSelectedElement = Navigatable.this.getFirstSelectedItem();
                Object newSelection = Navigatable.this.calculateNextSelection(firstSelectedElement, flag);
                if (newSelection != null) {
                    Navigatable.this.fireOpen(newSelection);
                }
            }
        });
        return false;
    }

    public void refresh() {
        if (this.treeVisitor == null) {
            this.treeVisitor = new TreeVisitor();
            this.contentProvider.runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, this.treeVisitor);
        } else {
            this.treeVisitor.reset();
        }
    }

    private Object getFirstSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection.getFirstElement();
    }

    private Object calculateNextSelection(Object currentSelection, int flag) {
        switch (flag) {
            case 1: {
                return this.getNextDiff(this.thisOrFirstItem(currentSelection));
            }
            case 2: {
                return this.getPreviousDiff(this.thisOrFirstItem(currentSelection));
            }
            case 3: {
                return this.getNextDiff(this.getFirstItem());
            }
            case 4: {
                return this.getPreviousDiff(this.getFirstItem());
            }
            case 80: {
                return this.getNextUnresolvedDiff(this.thisOrFirstItem(currentSelection));
            }
            case 81: {
                return this.getPreviousUnresolvedDiff(this.thisOrFirstItem(currentSelection));
            }
        }
        throw new IllegalStateException();
    }

    private Object thisOrFirstItem(Object object) {
        if (object != null) {
            return object;
        }
        return this.getFirstItem();
    }

    public void fireOpen(Object element) {
        StructuredSelection newSelection = new StructuredSelection(element);
        this.viewer.setSelection((ISelection)newSelection);
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, (ISelection)newSelection));
    }

    public WrappableTreeViewer getViewer() {
        return this.viewer;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public boolean openSelectedChange() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, selection));
        return true;
    }

    public boolean hasChange(int changeFlag) {
        Object firstSelectedItem = this.getFirstSelectedItem();
        switch (changeFlag) {
            case 1: {
                return this.getNextDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 2: {
                return this.getPreviousDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 80: {
                return this.getNextUnresolvedDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 3: {
                Object firstItemInTree = this.getFirstItem();
                return firstItemInTree != null && this.getNextDiff(firstItemInTree) != null;
            }
        }
        throw new IllegalStateException();
    }

    private Object getNextDiff(Object start) {
        return this.getNextItemWithDiff(start, false);
    }

    private Object getPreviousDiff(Object start) {
        return this.getPreviousItemWithDiff(start, false);
    }

    private Object getNextUnresolvedDiff(Object start) {
        Object nextUnresolvedDiff = this.getNextItemWithDiff(start, true);
        if (nextUnresolvedDiff == null) {
            nextUnresolvedDiff = this.getNextItemWithDiff(this.getFirstItem(), true);
        }
        return nextUnresolvedDiff;
    }

    private Object getPreviousUnresolvedDiff(Object start) {
        Object previousUnresolvedDiff = this.getPreviousItemWithDiff(start, true);
        if (previousUnresolvedDiff == null) {
            Object lastItem = this.getLastItem();
            previousUnresolvedDiff = this.hasDiff(lastItem, true) ? lastItem : this.getPreviousItemWithDiff(this.getLastItem(), true);
        }
        return previousUnresolvedDiff;
    }

    private Object getNextItemWithDiff(Object start, boolean onlyUnresolvedDiff) {
        Object item = this.getNextItem(start);
        while (item != null) {
            if (this.hasDiff(item, onlyUnresolvedDiff)) {
                return item;
            }
            item = this.getNextItem(item);
        }
        return null;
    }

    private Object getPreviousItemWithDiff(Object start, boolean onlyUnresolvedDiff) {
        Object item = this.getPreviousItem(start);
        while (item != null) {
            if (this.hasDiff(item, onlyUnresolvedDiff)) {
                return item;
            }
            item = this.getPreviousItem(item);
        }
        return null;
    }

    private boolean hasDiff(Object item, boolean onlyUnresolved) {
        EObject data = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item);
        if (data instanceof Diff) {
            Diff diff = (Diff)data;
            return !onlyUnresolved || diff.getState() == DifferenceState.UNRESOLVED;
        }
        return false;
    }

    private Object getFirstItem() {
        return this.viewer.getInput();
    }

    private Object getLastItem() {
        Object lastItem;
        Object parent = lastItem = this.viewer.getInput();
        while (parent != null) {
            if ((parent = this.getAncestor(parent)) == null) continue;
            lastItem = parent;
        }
        Object[] siblings = this.getSiblings(lastItem);
        lastItem = siblings[siblings.length - 1];
        lastItem = this.getLastDescendant(lastItem);
        return lastItem;
    }

    protected Object getNextItem(Object start) {
        Object[] children = this.getChildren(start);
        if (children.length > 0) {
            return children[0];
        }
        Object nextSibling = this.getNextSibling(start);
        if (nextSibling != null) {
            return nextSibling;
        }
        return this.getNextAncestor(start);
    }

    private Object getNextAncestor(Object item) {
        Object nextAncestor = null;
        Object ancestor = this.getAncestor(item);
        while (ancestor != null && nextAncestor == null) {
            nextAncestor = this.getNextSibling(ancestor);
            ancestor = this.getAncestor(ancestor);
        }
        return nextAncestor;
    }

    private Object getAncestor(Object item) {
        Object ancestor = this.allAncestors.get(item);
        if (ancestor == null) {
            Object input;
            ancestor = this.viewer.getParentElement(item);
            if (ancestor == null && item != null && !item.equals(input = this.getInput())) {
                ancestor = input;
            }
            this.allAncestors.put(item, ancestor);
        }
        return ancestor;
    }

    protected Object getPreviousItem(Object start) {
        Object previousSibling = this.getPreviousSibling(start);
        if (previousSibling != null) {
            return this.getLastDescendant(previousSibling);
        }
        Object parent = this.getAncestor(start);
        if (parent != null) {
            return parent;
        }
        return null;
    }

    private Object getLastDescendant(Object parent) {
        Object[] children = this.getChildren(parent);
        Object deepestChild = parent;
        while (children.length > 0) {
            deepestChild = children[children.length - 1];
            children = this.getChildren(deepestChild);
        }
        return deepestChild;
    }

    private Object[] getChildren(Object input) {
        Object[] children = this.allChildren.get(input);
        if (children == null) {
            children = this.viewer.getFilteredChildren(input);
            this.allChildren.put(input, children);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.allAncestors.put(child, input);
                ++n2;
            }
        }
        return children;
    }

    private Object getPreviousSibling(Object item) {
        Object[] siblings = this.getSiblings(item);
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == item) {
                if (--i >= 0) {
                    return siblings[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private Object getNextSibling(Object item) {
        Object[] siblings = this.getSiblings(item);
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == item) {
                if (++i < siblings.length) {
                    return siblings[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private Object[] getSiblings(Object item) {
        Object parent = this.getAncestor(item);
        if (parent == null) {
            return new Object[]{item};
        }
        return this.getChildren(parent);
    }

    private class TreeVisitor
    implements Runnable {
        private static final int TIMEOUT = 200;
        private Iterator<Object> visitor;

        public TreeVisitor() {
            this.reset();
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int count = 0;
            while (this.visitor.hasNext()) {
                if ((++count & 0xFF) == 0 && System.currentTimeMillis() - start > 200L) {
                    Navigatable.this.contentProvider.runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, this);
                    return;
                }
                this.visitor.next();
            }
            this.visitor = null;
        }

        public void reset() {
            Navigatable.this.allChildren.clear();
            Navigatable.this.allAncestors.clear();
            this.visitor = new AbstractTreeIterator<Object>(Navigatable.this.getFirstItem(), true){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends Object> getChildren(Object item) {
                    return Iterators.forArray((Object[])Navigatable.this.getChildren(item));
                }
            };
        }
    }
}

