/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;

public class CreateControlResource
extends AbstractControlResourceCommand {
    private static final String MODELSET_ERROR = Messages.getString("CreateControlResource.modelset.error");
    private static final String CREATION_RESOURCE_ERROR = Messages.getString("CreateControlResource.resource.error");

    public CreateControlResource(ControlModeRequest request) {
        super(request, Messages.getString("CreateControlResource.command.title"), null);
    }

    public CreateControlResource(ControlModeRequest request, String newFileExtension) {
        this(request);
        this.newFileExtension = newFileExtension;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        boolean resourceInSet;
        Resource resource = this.getResourceSet().getResource(this.getTargetUri(), false);
        boolean bl = resourceInSet = resource != null;
        if (resourceInSet && (this.failedToLoadBecauseNonExistent(resource) || this.isNotYetDeteted(resource))) {
            resource.getResourceSet().getResources().remove((Object)resource);
            resource = null;
            resourceInSet = false;
        }
        Resource newResource = null;
        if (resource == null) {
            newResource = this.getResourceSet().createResource(this.getTargetUri());
            if (newResource == null) {
                return CommandResult.newErrorCommandResult((String)CREATION_RESOURCE_ERROR);
            }
        } else {
            newResource = resource;
        }
        this.getRequest().setTargetResource(newResource, this.getFileExtension());
        newResource.setModified(true);
        this.getRequest().getModelSet().getResourcesToDeleteOnSave().remove(newResource.getURI());
        return CommandResult.newOKCommandResult((Object)newResource);
    }

    protected boolean isNotYetDeteted(Resource resource) {
        boolean result = false;
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            result = ((ModelSet)resourceSet).getResourcesToDeleteOnSave().contains(resource.getURI());
        }
        return result;
    }

    protected boolean failedToLoadBecauseNonExistent(Resource resource) {
        boolean result = false;
        if (resource.getContents().isEmpty() && !resource.getErrors().isEmpty()) {
            result = !resource.getResourceSet().getURIConverter().exists(resource.getURI(), null);
        }
        return result;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus superStatus = super.doUndo(monitor, info);
        Resource oldResource = this.getRequest().getTargetResource(this.getFileExtension());
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)MODELSET_ERROR).getStatus();
        }
        Resource resource = this.getTargetResrource(this.getRequest().getTargetObject());
        resource.setModified(true);
        if (!this.isControlledResourceLocked(this.getNewURI())) {
            this.getResourceSet().getResources().remove((Object)oldResource);
            modelSet.getResourcesToDeleteOnSave().add(oldResource.getURI());
        }
        oldResource.setModified(true);
        return superStatus;
    }

    protected URI getNewURI() {
        return this.getRequest().getNewURI();
    }

    protected Resource getTargetResrource(EObject objectToUncontrol) {
        return this.getRequest().getModelSet().getAssociatedResource(objectToUncontrol, this.getFileExtension(), true);
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Resource oldResource = this.getRequest().getTargetResource(this.getFileExtension());
        this.getResourceSet().getResources().add((Object)oldResource);
        ModelSet modelSet = this.getRequest().getModelSet();
        if (modelSet == null) {
            return CommandResult.newErrorCommandResult((String)MODELSET_ERROR).getStatus();
        }
        modelSet.getResourcesToDeleteOnSave().remove(oldResource.getURI());
        oldResource.setModified(true);
        return super.doRedo(monitor, info);
    }
}

