/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.model.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLElement {
    private String element;
    private int offset;
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private boolean isEndElement;
    private boolean isStartElement;
    private Pattern startElementNamePattern = Pattern.compile("<\\s*(?<name>\\w*).*", 32);
    private Pattern endElementNamePattern = Pattern.compile("</\\s*(?<name>\\w*).*", 32);
    private Pattern attributePattern = Pattern.compile("((?<key>\\w*)\\s*=\\s*\"(?<value>.*?)\")", 32);

    public XMLElement(String element, int offset) {
        this.element = element;
        this.offset = offset;
        this.isEndElement = element.matches("</(.|\n)*|(.|\n)*/>(.|\n)*");
        this.isStartElement = element.matches("<[^/](.|\n)*");
        Pattern namePattern = this.isStartElement() ? this.startElementNamePattern : this.endElementNamePattern;
        Matcher nameMatcher = namePattern.matcher(element);
        nameMatcher.matches();
        this.name = nameMatcher.group("name");
        Matcher attrMatcher = this.attributePattern.matcher(element);
        while (attrMatcher.find()) {
            String key = attrMatcher.group("key");
            String value = attrMatcher.group("value");
            this.attributes.put(key, value);
        }
    }

    public boolean isEndElement() {
        return this.isEndElement;
    }

    public boolean isStartElement() {
        return this.isStartElement;
    }

    public int getStartOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.element.length();
    }

    public String getAttributeValueByKey(String key) {
        return this.attributes.get(key);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.element;
    }
}

