/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GroupsInteractiveContent {
    private static final int DESCRIPTION_LABEL_HEIGHT_HINT = 40;
    private static final int DESCRIPTION_LABEL_WIDTH_HINT = 400;
    private static final String ENABLE_DOWN_IMG = "icons/full/pref16/down.gif";
    private static final String ENABLE_UP_IMG = "icons/full/pref16/up.gif";
    private final Label descriptionText;
    private ArrayList<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> descriptors;
    private Button downButton;
    private Button upButton;
    private ListViewer viewer;
    private final Composite viewerCompsite;

    public GroupsInteractiveContent(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(containerComposite);
        containerComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite interactiveComposite = new Composite(containerComposite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(interactiveComposite);
        interactiveComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label introductionText = new Label(interactiveComposite, 64);
        introductionText.setText(EMFCompareRCPUIMessages.getString("GroupsPreferencePage.viewerDescription.label"));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)introductionText);
        this.viewerCompsite = new Composite(interactiveComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.viewerCompsite);
        this.viewerCompsite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createButtonComposite(interactiveComposite);
        this.descriptionText = this.createDescriptionComposite(interactiveComposite);
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridData layoutData = new GridData(16384, 0x1000000, false, true, 1, 1);
        buttonComposite.setLayoutData((Object)layoutData);
        buttonComposite.setLayout((Layout)new RowLayout(512));
        this.upButton = new Button(buttonComposite, 0);
        this.upButton.setImage(EMFCompareRCPUIPlugin.getImage(ENABLE_UP_IMG));
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GroupsInteractiveContent.this.upButton.equals(e.getSource())) {
                    IItemDescriptor selection = GroupsInteractiveContent.this.getCurrentSelection();
                    int index = GroupsInteractiveContent.this.descriptors.indexOf(selection);
                    GroupsInteractiveContent.this.descriptors.remove(selection);
                    int newIndex = index - 1;
                    if (newIndex <= GroupsInteractiveContent.this.descriptors.size()) {
                        GroupsInteractiveContent.this.descriptors.add(newIndex, selection);
                        GroupsInteractiveContent.this.setViewerInput(GroupsInteractiveContent.this.descriptors);
                        GroupsInteractiveContent.this.select((IItemDescriptor<IDifferenceGroupProvider.Descriptor>)selection);
                    }
                }
            }
        });
        this.downButton = new Button(buttonComposite, 0);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GroupsInteractiveContent.this.downButton.equals(e.getSource())) {
                    IItemDescriptor selection = GroupsInteractiveContent.this.getCurrentSelection();
                    int index = GroupsInteractiveContent.this.descriptors.indexOf(selection);
                    GroupsInteractiveContent.this.descriptors.remove(selection);
                    int newIndex = index + 1;
                    if (newIndex <= GroupsInteractiveContent.this.descriptors.size()) {
                        GroupsInteractiveContent.this.descriptors.add(newIndex, selection);
                        GroupsInteractiveContent.this.setViewerInput(GroupsInteractiveContent.this.descriptors);
                        GroupsInteractiveContent.this.select((IItemDescriptor<IDifferenceGroupProvider.Descriptor>)selection);
                    }
                }
            }
        });
        this.downButton.setImage(EMFCompareRCPUIPlugin.getImage(ENABLE_DOWN_IMG));
    }

    private Label createDescriptionComposite(Composite composite) {
        Group descriptionComposite = new Group(composite, 0);
        descriptionComposite.setText(EMFCompareRCPUIMessages.getString("InteractiveUIContent.descriptionComposite.label"));
        GridLayoutFactory.swtDefaults().applyTo((Composite)descriptionComposite);
        descriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label engineDescriptionLabel = new Label((Composite)descriptionComposite, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, 40).applyTo((Control)engineDescriptionLabel);
        return engineDescriptionLabel;
    }

    private IItemDescriptor<IDifferenceGroupProvider.Descriptor> getCurrentSelection() {
        IStructuredSelection structSelection;
        Object first;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (first = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IItemDescriptor) {
            return (IItemDescriptor)first;
        }
        return null;
    }

    public List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> getOrderedItems() {
        return this.descriptors;
    }

    public Composite getViewerComposite() {
        return this.viewerCompsite;
    }

    private boolean isFirst(Object o) {
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            return this.descriptors.get(0).equals(o);
        }
        return false;
    }

    private boolean isLast(Object o) {
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            return this.descriptors.get(this.descriptors.size() - 1).equals(o);
        }
        return false;
    }

    public void select(IItemDescriptor<IDifferenceGroupProvider.Descriptor> descriptor) {
        this.viewer.setSelection((ISelection)new StructuredSelection(descriptor), true);
        this.updateLinkedElements(descriptor);
    }

    public void setViewerInput(List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> input) {
        if (this.viewer != null) {
            this.descriptors = Lists.newArrayList(input);
            this.viewer.setInput(this.descriptors);
        } else {
            EMFCompareRCPUIPlugin.getDefault().log(4, "Please initialize the viewer before setting input");
        }
    }

    public void setViewer(ListViewer inputViewer) {
        this.viewer = inputViewer;
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new DescriptionListener());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IItemDescriptor selection = GroupsInteractiveContent.this.getCurrentSelection();
                if (selection == null) {
                    GroupsInteractiveContent.this.upButton.setEnabled(false);
                    GroupsInteractiveContent.this.downButton.setEnabled(false);
                } else {
                    GroupsInteractiveContent.this.upButton.setEnabled(!GroupsInteractiveContent.this.isFirst(selection));
                    GroupsInteractiveContent.this.downButton.setEnabled(!GroupsInteractiveContent.this.isLast(selection));
                }
            }
        });
    }

    private void updateLinkedElements(IItemDescriptor<IDifferenceGroupProvider.Descriptor> descriptor) {
        this.descriptionText.setText(descriptor.getDescription());
    }

    private final class DescriptionListener
    implements ISelectionChangedListener {
        private DescriptionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection structSelection;
            Object selected;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selected = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IItemDescriptor) {
                IItemDescriptor desc = (IItemDescriptor)selected;
                String description = desc.getDescription();
                GroupsInteractiveContent.this.descriptionText.setText(description);
            }
        }
    }
}

