/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionsLoadedEvent;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOLockStateCache;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

public class CDOLockStatePrefetcher {
    public static final Predicate<CDOID> DEFAULT_OBJECT_FILTER = id -> true;
    private final IListener revisionManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDORevisionsLoadedEvent) {
                CDORevisionsLoadedEvent e = (CDORevisionsLoadedEvent)event;
                if (CDOLockStatePrefetcher.this.asyncUpdate) {
                    ExecutorService executorService = CDOLockStatePrefetcher.this.view.getExecutorService();
                    executorService.submit(() -> CDOLockStatePrefetcher.this.updateLockStates(e));
                } else {
                    CDOLockStatePrefetcher.this.updateLockStates(e);
                }
            }
        }
    };
    private final IListener viewListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle view) {
            CDOLockStatePrefetcher.this.dispose();
        }
    };
    private final InternalCDOView view;
    private final boolean asyncUpdate;
    private boolean updateOtherViews;
    private Predicate<CDOID> objectFilter = DEFAULT_OBJECT_FILTER;

    public CDOLockStatePrefetcher(CDOView view, boolean asyncUpdate) {
        this.view = (InternalCDOView)view;
        this.asyncUpdate = asyncUpdate;
        view.addListener(this.viewListener);
        view.getSession().getRevisionManager().addListener(this.revisionManagerListener);
    }

    public CDOLockStatePrefetcher(CDOView view) {
        this(view, true);
    }

    public final boolean isUpdateOtherViews() {
        return this.updateOtherViews;
    }

    public final void setUpdateOtherViews(boolean updateOtherViews) {
        this.updateOtherViews = updateOtherViews;
    }

    public final Predicate<CDOID> getObjectFilter() {
        return this.objectFilter;
    }

    public final void setObjectFilter(Predicate<CDOID> objectFilter) {
        this.objectFilter = objectFilter;
    }

    public final InternalCDOView getView() {
        return this.view;
    }

    public final boolean isAsyncUpdate() {
        return this.asyncUpdate;
    }

    public void dispose() {
        this.view.getSession().getRevisionManager().removeListener(this.revisionManagerListener);
        this.view.removeListener(this.viewListener);
    }

    protected final Object getLockTarget(CDOObject object) {
        return CDOViewImpl.getLockTarget(object);
    }

    protected final CDOLockState getLockState(CDOObject object) {
        Object[] lockStates = this.view.getLockStates(Collections.singleton(object.cdoID()), false);
        if (!ObjectUtil.isEmpty((Object[])lockStates)) {
            return lockStates[0];
        }
        return null;
    }

    private void addMissingLockState(CDOObject object, List<CDOLockState> missingLockStates) {
        Object lockedObject;
        if (object != null && this.getLockState(object) == null && (lockedObject = this.getLockTarget(object)) != null) {
            missingLockStates.add(CDOLockUtil.createLockState((Object)lockedObject));
        }
    }

    private void updateLockStates(CDORevisionsLoadedEvent event) {
        this.view.syncExec(() -> {
            block12: {
                try {
                    HashSet<CDOID> ids = new HashSet<CDOID>();
                    Predicate<CDOID> filter = this.objectFilter;
                    for (CDORevision revision : event.getPrimaryLoadedRevisions()) {
                        CDOID id;
                        if (revision == null || (id = revision.getID()) == null || !filter.test(id)) continue;
                        boolean normalObject = !revision.isResourceNode();
                        try {
                            CDOObject object = this.view.getObject(id, normalObject);
                            if (object == null) continue;
                            ids.add(id);
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (!ids.isEmpty()) {
                        CDOSessionProtocol sessionProtocol = this.view.getSession().getSessionProtocol();
                        List<CDOLockState> loadedLockStates = sessionProtocol.getLockStates2(this.view.getBranch().getID(), ids, event.getPrefetchDepth());
                        this.updateLockStates(loadedLockStates, true);
                        ArrayList<CDOLockState> missingLockStates = new ArrayList<CDOLockState>();
                        for (CDOID id : ids) {
                            try {
                                CDOObject object = this.view.getObject(id, false);
                                if (object == null) continue;
                                this.addMissingLockState(object, missingLockStates);
                            }
                            catch (ObjectNotFoundException object) {
                                // empty catch block
                            }
                        }
                        for (CDORevision revision : event.getAdditionalLoadedRevisions()) {
                            CDOID id = revision.getID();
                            if (id == null || !filter.test(id)) continue;
                            boolean normalObject = !revision.isResourceNode();
                            try {
                                CDOObject object = this.view.getObject(id, normalObject);
                                if (object == null) continue;
                                this.addMissingLockState(object, missingLockStates);
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                // empty catch block
                            }
                        }
                        this.updateLockStates(missingLockStates, false);
                    }
                }
                catch (Exception ex) {
                    if (!this.view.isActive()) break block12;
                    OM.LOG.error((Throwable)ex);
                }
            }
        });
    }

    private void updateLockStates(List<CDOLockState> lockStates, boolean loadOnDemand) {
        block2: {
            try {
                CDOBranch branch = this.view.getBranch();
                CDOLockStateCache lockStateCache = this.view.getSession().getLockStateCache();
                lockStateCache.addLockStates(branch, lockStates, null);
            }
            catch (Exception ex) {
                if (!this.view.isActive()) break block2;
                OM.LOG.error((Throwable)ex);
            }
        }
    }
}

