/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.ColumnResizer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyAccessor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyItem;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

class PropertyTreeMergeViewer
extends TreeMergeViewer {
    final ColumnResizer.Handler columnResizer;
    private PropertyItem rootPropertyItem;

    PropertyTreeMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, ICompareColor.Provider colorProvider, EMFCompareConfiguration configuration) {
        super(parent, side, colorProvider, (IEMFCompareConfiguration)configuration);
        AdapterFactory adapterFactory = configuration.getAdapterFactory();
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory){

            public void notifyChanged(Notification notification) {
            }
        };
        this.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontProvider(adapterFactory, (Viewer)this));
        TreeViewer treeViewer = this.getStructuredViewer();
        treeViewer.setAutoExpandLevel(10);
        final Tree tree = treeViewer.getTree();
        TreeColumn propColumn = new TreeColumn(tree, 16384, 0);
        propColumn.setText(EMFCompareIDEUIMessages.getString("PropertyContentMergeViewer.property.label"));
        TreeColumn valueColumn = new TreeColumn(tree, 16384, 1);
        valueColumn.setText(EMFCompareIDEUIMessages.getString("PropertyContentMergeViewer.value.label"));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.columnResizer = ColumnResizer.addColumnResizer(tree);
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                this.update((TreeItem)event.item, true);
            }

            public void treeCollapsed(TreeEvent event) {
                this.update((TreeItem)event.item, false);
            }

            private void update(TreeItem treeItem, boolean expanded) {
                PropertyItem propertyItem = (PropertyItem)((Object)treeItem.getData());
                propertyItem.update(treeItem, expanded);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeItem treeItem = tree.getItem(new Point(event.x, event.y));
                if (treeItem != null && treeItem.getItemCount() > 0) {
                    boolean expanded = !treeItem.getExpanded();
                    treeItem.setExpanded(expanded);
                    PropertyItem propertyItem = (PropertyItem)((Object)treeItem.getData());
                    propertyItem.update(treeItem, expanded);
                }
            }
        });
    }

    protected IAction createAction(MergeMode mode, Diff diff) {
        return new MergeAction(this.getCompareConfiguration(), EMFCompareRCPPlugin.getDefault().getMergerRegistry(), mode, null, (IStructuredSelection)new StructuredSelection((Object)diff));
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.rootPropertyItem = ((PropertyAccessor)input).getRootPropertyItem();
        TreeViewer treeViewer = this.getStructuredViewer();
        treeViewer.setSelection(null);
        treeViewer.setInput((Object)this.rootPropertyItem);
        this.columnResizer.resizeColumns();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new PropertyTreeViewer(parent, this.getRootPropertyItem(), 101124);
    }

    public PropertyItem getRootPropertyItem() {
        return this.rootPropertyItem;
    }
}

