/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.providers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateChildViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.CustomAbstractViewProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.RepresentationKind;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionSingleton;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionsRegistry;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.IdentityGraphicalElementType;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class ExpandViewProvider
extends CustomAbstractViewProvider
implements IViewProvider {
    private static final String DEBUG_PREFIX = "[EXPANSION_DIAGRAM]";
    protected Map<String, Class<?>> nodeMap = new HashMap();
    protected Map<String, Class<?>> edgeMap = new HashMap();
    protected DiagramExpansionsRegistry diagramExpansionRegistry;

    public ExpandViewProvider() {
        this.initDiagramType();
        this.initGraphicalTypeRegistry();
        this.diagramExpansionRegistry = DiagramExpansionSingleton.getInstance().getDiagramExpansionRegistry();
    }

    protected void initGraphicalTypeRegistry() {
        this.registry = new IdentityGraphicalElementType();
    }

    protected boolean provides(CreateNodeViewOperation operation) {
        if (!ProviderServiceUtil.isEnabled((IViewProvider)this, (View)operation.getContainerView())) {
            return false;
        }
        return this.providesFromExpansionModel((CreateChildViewOperation)operation);
    }

    protected boolean provides(CreateEdgeViewOperation operation) {
        if (!ProviderServiceUtil.isEnabled((IViewProvider)this, (View)operation.getContainerView())) {
            return false;
        }
        return this.providesFromExpansionModel((CreateChildViewOperation)operation);
    }

    protected boolean providesFromExpansionModel(CreateChildViewOperation operation) {
        String currentDiagramType = this.getDiagramType(operation.getContainerView());
        if (this.diagramExpansionRegistry.mapChildreen.get(currentDiagramType) == null) {
            Activator.log.trace("expansion", String.valueOf(((Object)((Object)this)).getClass().getName()) + " " + currentDiagramType + " not supported by loaded expansion model");
            return false;
        }
        String graphicalType = operation.getSemanticHint();
        String containerType = operation.getContainerView() instanceof Diagram ? currentDiagramType : operation.getContainerView().getType();
        Activator.log.trace("expansion", String.valueOf(((Object)((Object)this)).getClass().getName()) + " try to create view in the container " + containerType + " the view " + operation.getSemanticHint());
        List<String> possibleChildreenIDs = this.diagramExpansionRegistry.mapChildreen.get((Object)currentDiagramType).parentChildrenRelation.get(containerType);
        if (possibleChildreenIDs == null) {
            return false;
        }
        return possibleChildreenIDs.contains(graphicalType);
    }

    protected Class<?> getNodeViewClass(IAdaptable semanticAdapter, View containerView, String graphicalType) {
        return this.getViewFactory(containerView, graphicalType);
    }

    protected Class<?> getViewFactory(View containerView, String graphicalType) {
        EObject eObject;
        String currentDiagramType = this.getDiagramType(containerView);
        if (this.diagramExpansionRegistry.mapChildreen.get(currentDiagramType) != null && (eObject = (EObject)this.diagramExpansionRegistry.mapChildreen.get((Object)currentDiagramType).IDMap.get(graphicalType)) instanceof AbstractRepresentation) {
            String viewFactoryPath = ((AbstractRepresentation)eObject).getViewFactory();
            if (viewFactoryPath != null && !"".equals(viewFactoryPath.trim())) {
                return ClassLoaderHelper.loadClass((String)viewFactoryPath);
            }
            RepresentationKind representationKind = ((AbstractRepresentation)eObject).getKind();
            if (representationKind != null && (viewFactoryPath = representationKind.getViewFactory()) != null) {
                return ClassLoaderHelper.loadClass((String)viewFactoryPath);
            }
        }
        return null;
    }

    protected String getDiagramType(View currentView) {
        Diagram diagram = currentView.getDiagram();
        String currentDiagramType = null;
        ViewPrototype viewPrototype = DiagramUtils.getPrototype((Diagram)diagram);
        currentDiagramType = viewPrototype != null ? viewPrototype.getLabel() : diagram.getType();
        this.diagramType = currentDiagramType;
        return currentDiagramType;
    }

    protected Class<?> getEdgeViewClass(IAdaptable semanticAdapter, View containerView, String graphicalType) {
        return this.getViewFactory(containerView, graphicalType);
    }

    protected void initDiagramType() {
        this.diagramType = null;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        return false;
    }
}

