/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gmf.runtime.draw2d.ui.graph.BorderNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstantSizeNode;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.draw2d.ui.graph.GraphUtilities;

class PreRouteEdges {
    private DirectedGraph g;

    public PreRouteEdges(DirectedGraph g) {
        this.g = g;
    }

    void preRouteEdges() {
        int i = 0;
        while (i < this.g.nodes.size()) {
            Node n = this.g.nodes.getNode(i);
            if (n instanceof ConstantSizeNode) {
                this.preRouteEdgesFromNode((ConstantSizeNode)n);
            }
            ++i;
        }
    }

    private void preRouteEdgesFromNode(ConstantSizeNode n) {
        ArrayList<BorderNode> leftBorderNodes = new ArrayList<BorderNode>();
        ArrayList<BorderNode> rightBorderNodes = new ArrayList<BorderNode>();
        for (BorderNode bn : n.borderNodes) {
            if (bn.position == 16) {
                rightBorderNodes.add(bn);
                continue;
            }
            if (bn.position != 8) continue;
            leftBorderNodes.add(bn);
        }
        this.createRoutingPointsForSideBorderNodes(leftBorderNodes, n, 8);
        this.createRoutingPointsForSideBorderNodes(rightBorderNodes, n, 16);
    }

    private void createRoutingPointsForSideBorderNodes(List<BorderNode> nodes, ConstantSizeNode parentNode, int position) {
        int nodePadding;
        ArrayList<ConstrainedEdge> incomingEdges = new ArrayList<ConstrainedEdge>();
        ArrayList<ConstrainedEdge> outgoingEdges = new ArrayList<ConstrainedEdge>();
        int maxBorderItemOutsideWidth = this.initBorderNodeEdgesLists(nodes, incomingEdges, outgoingEdges, position);
        int n = nodePadding = position == 8 ? this.g.getPadding((Node)parentNode).left : this.g.getPadding((Node)parentNode).right;
        if (nodePadding <= maxBorderItemOutsideWidth) {
            throw new RuntimeException("Node padding must be greater than the the width of the widest border node");
        }
        if (incomingEdges.isEmpty() || outgoingEdges.isEmpty()) {
            return;
        }
        int incomingPadding = (nodePadding - maxBorderItemOutsideWidth) / (incomingEdges.size() + 1);
        int outgoingPadding = (nodePadding - maxBorderItemOutsideWidth) / (outgoingEdges.size() + 1);
        Collections.sort(incomingEdges, new Comparator<ConstrainedEdge>(){

            @Override
            public int compare(ConstrainedEdge e1, ConstrainedEdge e2) {
                int diff = GraphUtilities.getIncomingEdgeBendpointX(e2, PreRouteEdges.this.g) - GraphUtilities.getIncomingEdgeBendpointX(e1, PreRouteEdges.this.g);
                if (e1.targetConstraint.position == 8) {
                    return diff;
                }
                return -diff;
            }
        });
        Collections.sort(outgoingEdges, new Comparator<ConstrainedEdge>(){

            @Override
            public int compare(ConstrainedEdge e1, ConstrainedEdge e2) {
                int diff = GraphUtilities.getOutogingEdgeBendpointX(e2, PreRouteEdges.this.g) - GraphUtilities.getOutogingEdgeBendpointX(e1, PreRouteEdges.this.g);
                if (e1.sourceConstraint.position == 8) {
                    return diff;
                }
                return -diff;
            }
        });
        int rankHeight = GraphUtilities.getRankHeightFromNode(parentNode, this.g);
        Point incomingStartPt = position == 8 ? new Point(parentNode.x - maxBorderItemOutsideWidth, parentNode.y) : new Point(parentNode.x + parentNode.width + maxBorderItemOutsideWidth, parentNode.y);
        Point outgoingStartPt = position == 8 ? new Point(parentNode.x - maxBorderItemOutsideWidth, parentNode.y + rankHeight) : new Point(parentNode.x + parentNode.width + maxBorderItemOutsideWidth, parentNode.y + parentNode.height);
        Dimension incomingOffset = position == 8 ? new Dimension(-incomingPadding, 0) : new Dimension(incomingPadding, 0);
        Dimension outgoingOffset = position == 8 ? new Dimension(-outgoingPadding, 0) : new Dimension(outgoingPadding, 0);
        this.padBendpointsForEdges(incomingEdges, incomingStartPt, incomingOffset, true);
        this.padBendpointsForEdges(outgoingEdges, outgoingStartPt, outgoingOffset, false);
    }

    private void padBendpointsForEdges(List<ConstrainedEdge> edges, Point startPoint, Dimension offset, boolean incoming) {
        Point current = startPoint.getCopy().translate(offset);
        for (ConstrainedEdge e : edges) {
            if (incoming) {
                e.endingRoutedPoints.addPoint(current);
                if (e.targetConstraint.minIncomingPadding > 0 || e.targetConstraint.minOutgoingPadding > 0) {
                    e.endingRoutedPoints.addPoint(current.x, e.end.y);
                }
                e.endingRoutedPoints.addPoint(e.end);
            } else {
                e.startingRoutedPoints.addPoint(e.start);
                if (e.sourceConstraint.minIncomingPadding > 0 || e.sourceConstraint.minOutgoingPadding > 0) {
                    e.startingRoutedPoints.addPoint(current.x, e.start.y);
                }
                e.startingRoutedPoints.addPoint(current);
            }
            current.translate(offset);
        }
    }

    private int initBorderNodeEdgesLists(List<BorderNode> nodes, List<ConstrainedEdge> incomingEdges, List<ConstrainedEdge> outgoingEdges, int position) {
        int maxBorderNodeOutsideWidth = 0;
        for (BorderNode bn : nodes) {
            if (bn.position != position) continue;
            incomingEdges.addAll((Collection<ConstrainedEdge>)bn.incomingJointEdges.edges);
            outgoingEdges.addAll((Collection<ConstrainedEdge>)bn.outgoingJointEdges.edges);
            maxBorderNodeOutsideWidth = Math.max(maxBorderNodeOutsideWidth, (int)((float)bn.width * bn.getOutsideRatio()));
        }
        return maxBorderNodeOutsideWidth;
    }
}

