/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;

public class StringDirectorySelector
extends StringEditor {
    private Button browse;
    private Button browseWorkspace;
    private boolean allowWorkspace = true;
    private boolean allowFileSystem = true;
    private boolean readOnly = false;
    private boolean allowIProject = true;
    private boolean allowIFolder = true;
    private boolean allowIWorkspaceRoot = true;

    public void setAllowIProject(boolean allowIProject) {
        this.allowIProject = allowIProject;
    }

    public void setAllowIFolder(boolean allowIFolder) {
        this.allowIFolder = allowIFolder;
    }

    public void setAllowIWorkspaceRoot(boolean allowIWorkspaceRoot) {
        this.allowIWorkspaceRoot = allowIWorkspaceRoot;
    }

    public StringDirectorySelector(Composite parent, int style) {
        super(parent, style);
        ((GridLayout)this.getLayout()).numColumns = 5;
        this.browse = factory.createButton((Composite)this, Messages.StringFileSelector_Browse, 8);
        this.browse.setLayoutData((Object)new GridData());
        this.browseWorkspace = factory.createButton((Composite)this, Messages.StringFileSelector_BrowseWorkspace, 8);
        this.browseWorkspace.setLayoutData((Object)new GridData());
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                File file = FileUtil.getFolder(StringDirectorySelector.this.text.getText());
                DirectoryDialog dialog = new DirectoryDialog(StringDirectorySelector.this.getShell());
                if (StringDirectorySelector.this.labelText != null) {
                    dialog.setText(StringDirectorySelector.this.labelText);
                }
                if (file != null) {
                    dialog.setFilterPath(file.getAbsolutePath());
                }
                if ((result = dialog.open()) == null) {
                    return;
                }
                StringDirectorySelector.this.setResult(result);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browseWorkspace.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                int code;
                LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
                try {
                    labelProviderService.startService();
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                }
                ILabelProvider labelProvider = labelProviderService.getLabelProvider();
                IFile currentFile = FileUtil.getIFile(StringDirectorySelector.this.text.getText());
                TreeSelectorDialog dialog = new TreeSelectorDialog(StringDirectorySelector.this.getShell());
                if (StringDirectorySelector.this.labelText != null) {
                    dialog.setTitle(StringDirectorySelector.this.labelText);
                }
                WorkspaceContentProvider contentProvider = new WorkspaceContentProvider(){

                    @Override
                    public boolean isValidValue(Object element) {
                        return StringDirectorySelector.this.isValidFolder(element);
                    }
                };
                dialog.setContentProvider(contentProvider);
                dialog.setLabelProvider(labelProvider);
                if (currentFile != null && currentFile.exists()) {
                    dialog.setInitialSelections(new IFile[]{currentFile});
                }
                if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0) {
                    Object file = result[0];
                    if (StringDirectorySelector.this.isValidFolder(result[0])) {
                        StringDirectorySelector.this.setResult((IContainer)file);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setResult(IContainer file) {
        this.text.setText(file.getFullPath().toString());
        this.notifyChange();
    }

    protected void setResult(File file) {
        if (file.isDirectory()) {
            this.text.setText(file.getAbsolutePath());
            this.notifyChange();
        }
    }

    protected void setResult(String path) {
        this.text.setText(path);
        this.notifyChange();
    }

    @Override
    public Object getEditableType() {
        return String.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.readOnly = readOnly;
        this.updateButtons();
    }

    public void setAllowWorkspace(boolean allowWorkspace) {
        this.allowWorkspace = allowWorkspace;
        this.updateButtons();
    }

    public void setAllowFileSystem(boolean allowFileSystem) {
        this.allowFileSystem = allowFileSystem;
        this.updateButtons();
    }

    private void updateButtons() {
        boolean enableWorkspace = !this.readOnly && this.allowWorkspace;
        boolean enableFileSystem = !this.readOnly && this.allowFileSystem;
        this.browseWorkspace.setEnabled(enableWorkspace);
        this.browse.setEnabled(enableFileSystem);
    }

    private boolean isValidFolder(Object element) {
        if (element instanceof IProject && this.allowIProject) {
            return true;
        }
        if (element instanceof IFolder && this.allowIFolder) {
            return true;
        }
        return element instanceof IWorkspaceRoot && this.allowIWorkspaceRoot;
    }
}

