/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.bugzilla.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;

public final class TaskAttachmentTableEditorHyperlink
implements IHyperlink {
    private final IRegion region;
    private final TaskRepository repository;
    private final String attachmentId;

    public TaskAttachmentTableEditorHyperlink(IRegion region, TaskRepository repository, String attachmentId) {
        Assert.isNotNull((Object)repository);
        this.region = region;
        this.repository = repository;
        this.attachmentId = attachmentId;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return MessageFormat.format(Messages.TaskAttachmentTableEditorHyperlink_Show_Attachment_X_in_Y, this.attachmentId);
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        AbstractTaskEditorPage page = this.getTaskEditorPage();
        if (page != null && !page.selectReveal((Object)("task.common.attachment-" + this.attachmentId))) {
            String msg = NLS.bind((String)Messages.TaskAttachmentTableEditorHyperlink_QuestionMsg, (Object)this.attachmentId);
            if (MessageDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.TaskAttachmentTableEditorHyperlink_AttachmentNotFound, (String)msg)) {
                String url = String.valueOf(this.repository.getUrl()) + "/attachment.cgi?id=" + this.attachmentId;
                TasksUiUtil.openUrl((String)url);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachmentId == null ? 0 : this.attachmentId.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskAttachmentTableEditorHyperlink other = (TaskAttachmentTableEditorHyperlink)obj;
        if (this.attachmentId == null ? other.attachmentId != null : !this.attachmentId.equals(other.attachmentId)) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals((Object)other.repository));
    }

    public String toString() {
        return "TaskAttachmentHyperlink [attachmentId=" + this.attachmentId + ", region=" + this.region + ", repository=" + this.repository + "]";
    }

    protected AbstractTaskEditorPage getTaskEditorPage() {
        TaskEditor taskEditor;
        IFormPage formPage;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart editorPart = activePage.getActiveEditor();
        AbstractTaskEditorPage taskEditorPage = null;
        if (editorPart instanceof TaskEditor && (formPage = (taskEditor = (TaskEditor)editorPart).getActivePageInstance()) instanceof AbstractTaskEditorPage) {
            taskEditorPage = (AbstractTaskEditorPage)formPage;
        }
        return taskEditorPage;
    }
}

