/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.log;

public abstract class Logger {
    private static final Object[] EMPTY_ARGS = new Object[0];

    public abstract boolean isErrorEnabled();

    public abstract void error(Throwable var1, String var2);

    public abstract boolean isWarnEnabled();

    public abstract void warn(Throwable var1, String var2);

    public abstract boolean isInfoEnabled();

    public abstract void info(Throwable var1, String var2);

    public abstract boolean isTraceEnabled();

    public abstract void trace(Throwable var1, String var2);

    public abstract boolean isDebugEnabled();

    public abstract void debug(Throwable var1);

    public abstract void debug(Throwable var1, String var2);

    public void debug(String message) {
        this.debug(null, message);
    }

    public void debug(String format, Object arg) {
        this.debug(Logger.internalBind(format, null, String.valueOf(arg), null));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(Logger.internalBind(format, null, String.valueOf(arg1), String.valueOf(arg2)));
    }

    public void debug(String format, Object[] args) {
        this.debug(Logger.internalBind(format, args, null, null));
    }

    public void error(Throwable t) {
        this.error(t, null);
    }

    public void error(String message) {
        this.error(null, message);
    }

    public void error(String format, Object arg) {
        this.error(Logger.internalBind(format, null, String.valueOf(arg), null));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(Logger.internalBind(format, null, String.valueOf(arg1), String.valueOf(arg2)));
    }

    public void error(String format, Object[] args) {
        this.error(Logger.internalBind(format, args, null, null));
    }

    public void info(Throwable t) {
        this.info(t, null);
    }

    public void info(String message) {
        this.info(null, message);
    }

    public void info(String format, Object arg) {
        this.info(Logger.internalBind(format, null, String.valueOf(arg), null));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(Logger.internalBind(format, null, String.valueOf(arg1), String.valueOf(arg2)));
    }

    public void info(String format, Object[] args) {
        this.info(Logger.internalBind(format, args, null, null));
    }

    public void trace(Throwable t) {
        this.trace(t, null);
    }

    public void trace(String message) {
        this.trace(null, message);
    }

    public void trace(String format, Object arg) {
        this.trace(Logger.internalBind(format, null, String.valueOf(arg), null));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(Logger.internalBind(format, null, String.valueOf(arg1), String.valueOf(arg2)));
    }

    public void trace(String format, Object[] args) {
        this.trace(Logger.internalBind(format, args, null, null));
    }

    public void warn(Throwable t) {
        this.warn(t, null);
    }

    public void warn(String message) {
        this.warn(null, message);
    }

    public void warn(String format, Object arg) {
        this.warn(Logger.internalBind(format, null, String.valueOf(arg), null));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(Logger.internalBind(format, null, String.valueOf(arg1), String.valueOf(arg2)));
    }

    public void warn(String format, Object[] args) {
        this.warn(Logger.internalBind(format, args, null, null));
    }

    private static String internalBind(String message, Object[] args, String argZero, String argOne) {
        if (message == null) {
            return "No message available.";
        }
        if (args == null || args.length == 0) {
            args = EMPTY_ARGS;
        }
        int length = message.length();
        int bufLen = length + args.length * 5;
        if (argZero != null) {
            bufLen += argZero.length() - 3;
        }
        if (argOne != null) {
            bufLen += argOne.length() - 3;
        }
        StringBuilder buffer = new StringBuilder(bufLen < 0 ? 0 : bufLen);
        int i = 0;
        while (i < length) {
            char c = message.charAt(i);
            switch (c) {
                case '{': {
                    int index = message.indexOf(125, i);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    if (++i >= length) {
                        buffer.append(c);
                        break;
                    }
                    int number = -1;
                    try {
                        number = Integer.parseInt(message.substring(i, index));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    if (number == 0 && argZero != null) {
                        buffer.append(argZero);
                    } else if (number == 1 && argOne != null) {
                        buffer.append(argOne);
                    } else {
                        if (number >= args.length || number < 0) {
                            buffer.append("<missing argument>");
                            i = index;
                            break;
                        }
                        buffer.append(args[number]);
                    }
                    i = index;
                    break;
                }
                case '\'': {
                    int nextIndex = i + 1;
                    if (nextIndex >= length) {
                        buffer.append(c);
                        break;
                    }
                    char next = message.charAt(nextIndex);
                    if (next == '\'') {
                        ++i;
                        buffer.append(c);
                        break;
                    }
                    int index = message.indexOf(39, nextIndex);
                    if (index == -1) {
                        buffer.append(c);
                        break;
                    }
                    buffer.append(message.substring(nextIndex, index));
                    i = index;
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

