/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.parsers;

import java.io.IOException;
import java.io.Reader;

public class RewindableTextStream {
    private static final int BUFFER_SIZE = 1024;
    private static final int RING_SIZE = 1024;
    private Reader reader;
    private char[] buffer;
    private int bufferStart;
    private int bufferLength;
    private boolean atEnd;
    private char[] ring;
    private int ringStart;
    private int ringNextEntry;
    private long counter;

    public RewindableTextStream(Reader reader) {
        this.reader = reader;
        this.buffer = new char[1024];
        this.bufferStart = 0;
        this.bufferLength = 0;
        this.ring = new char[1024];
        this.ringStart = 0;
        this.ringNextEntry = 0;
        this.counter = 0L;
    }

    public boolean isAtEnd() {
        return this.atEnd;
    }

    public void rewind(int count) {
        this.ringStart -= count;
        this.counter -= (long)count;
        if (this.ringStart < 0) {
            this.ringStart += 1024;
        }
    }

    public char read() {
        if (this.atEnd) {
            return '\u0000';
        }
        ++this.counter;
        if (this.ringStart != this.ringNextEntry) {
            this.atEnd = false;
            char value = this.ring[this.ringStart++];
            if (this.ringStart == 1024) {
                this.ringStart = 0;
            }
            return value;
        }
        return this.readBuffer();
    }

    private char readBuffer() {
        if (this.bufferStart == this.bufferLength) {
            this.bufferLength = -1;
            try {
                this.bufferLength = this.reader.read(this.buffer, 0, 1024);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bufferStart = 0;
            if (this.bufferLength <= 0) {
                this.atEnd = true;
                return '\u0000';
            }
        }
        this.atEnd = false;
        char c = this.buffer[this.bufferStart++];
        this.ring[this.ringNextEntry++] = c;
        if (this.ringNextEntry == 1024) {
            this.ringNextEntry = 0;
        }
        this.ringStart = this.ringNextEntry;
        return c;
    }

    public long getReadCharacters() {
        return this.counter;
    }
}

