/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.handler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.properties.ui.creation.PropertyEditorFactory;
import org.eclipse.papyrus.uml.m2m.qvto.common.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.MigrationParametersFactory;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.IImportTransformationLauncher;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractMigrationHandler
extends AbstractHandler {
    private Set<String> extensionOfFilesToImport;

    protected AbstractMigrationHandler(Set<String> acceptedFileExtension) {
        this.extensionOfFilesToImport = acceptedFileExtension;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        HashSet<IFile> filesToImport = new HashSet<IFile>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                String fileExtension;
                IFile selectedFile;
                if (!(selectedElement instanceof IAdaptable) || (selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class)) == null || !this.extensionOfFilesToImport.contains(fileExtension = selectedFile.getFileExtension())) continue;
                filesToImport.add(selectedFile);
            }
        }
        if (filesToImport.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> iter = this.extensionOfFilesToImport.iterator();
            while (iter.hasNext()) {
                builder.append("*.");
                builder.append(iter.next());
                if (!iter.hasNext()) continue;
                builder.append(", ");
            }
            Activator.log.warn(NLS.bind((String)"The selection doesn't contain any file with one of these extensions: {0}", (Object)builder.toString()));
        } else {
            this.importFiles(filesToImport, event);
        }
        return null;
    }

    public void importFiles(Set<IFile> selectedFiles, ExecutionEvent event) {
        ThreadConfig config = this.getTransformationParameters(event);
        if (config == null) {
            return;
        }
        Shell baseControl = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (baseControl != null && !baseControl.isDisposed() && baseControl.getParent() != null) {
            baseControl = baseControl.getParent();
        }
        if (baseControl == null || baseControl.isDisposed()) {
            baseControl = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        this.runTransformation(config, (Control)baseControl, selectedFiles);
    }

    protected void runTransformation(ThreadConfig config, Control baseControl, Set<IFile> selectedFiles) {
        LinkedList<URI> urisToImport = new LinkedList<URI>();
        for (IFile selectedFile : selectedFiles) {
            URI uri = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
            urisToImport.add(uri);
        }
        this.runTransformation(config, baseControl, urisToImport);
    }

    protected void runTransformation(ThreadConfig config, Control baseControl, List<URI> urisToImport) {
        IImportTransformationLauncher launcher = this.createImportTransformationLauncher(config, baseControl);
        launcher.run(urisToImport);
    }

    protected abstract IImportTransformationLauncher createImportTransformationLauncher(ThreadConfig var1, Control var2);

    public ThreadConfig getTransformationParameters(ExecutionEvent event) {
        ThreadConfig config = this.createConfigParameters();
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        final AtomicBoolean okPressed = new AtomicBoolean(true);
        PropertyEditorFactory factory = new PropertyEditorFactory(){

            public String getEditionDialogTitle(Object objectToEdit) {
                return "Transformation parameters";
            }

            protected void handleEditCancelled(Control widget, Object source) {
                okPressed.set(false);
                super.handleEditCancelled(widget, source);
            }
        };
        Object result = factory.edit((Control)activeShell, (Object)config);
        if (!okPressed.get()) {
            return null;
        }
        if (result instanceof ThreadConfig) {
            config = (ThreadConfig)result;
        }
        return config;
    }

    protected ThreadConfig createConfigParameters() {
        return MigrationParametersFactory.eINSTANCE.createThreadConfig();
    }
}

