/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.hook;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.hook.IResourceSetHook;
import org.eclipse.emf.compare.ide.internal.EMFCompareIDEMessages;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;

class ResourceSetHookDescriptor {
    private final IConfigurationElement element;
    private boolean error;

    ResourceSetHookDescriptor(IConfigurationElement element) {
        this.element = element;
    }

    public IResourceSetHook getHook() {
        if (!this.error) {
            try {
                return (IResourceSetHook)this.element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                this.error = true;
                String contributorName = this.element.getDeclaringExtension().getContributor().getName();
                String message = EMFCompareIDEMessages.getString("ResourceSetHookRegistry.hookInstanceError", contributorName);
                Status status = new Status(4, contributorName, String.valueOf(message) + this.element.getDeclaringExtension().getContributor().getName(), (Throwable)e);
                EMFCompareRCPPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }
}

