/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.serialization;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.impl.GrammarElementsInterner;
import org.eclipse.xtext.nodemodel.serialization.SerializationUtil;
import org.eclipse.xtext.resource.XtextResource;

public class DeserializationConversionContext {
    private EObject[] grammarIdToGrammarElementMap;
    private final List<EObject> idToEObjectMap;
    private final IGrammarAccess grammarAccess;
    private final GrammarElementsInterner arrayInterner;
    private final String completeContent;
    private boolean hasErrors;

    public DeserializationConversionContext(XtextResource xr, String completeContent) throws IOException {
        this.grammarAccess = xr.getResourceServiceProvider().get(IGrammarAccess.class);
        this.idToEObjectMap = Lists.newArrayList();
        this.completeContent = completeContent;
        this.arrayInterner = new GrammarElementsInterner();
        this.hasErrors = false;
        this.fillIdToEObjectMap((Resource)xr);
    }

    public void setGrammarIdToURIMap(String[] grammarIdToURIMap) {
        this.grammarIdToGrammarElementMap = new EObject[grammarIdToURIMap.length];
        ResourceSet grammarResourceSet = this.grammarAccess.getGrammar().eResource().getResourceSet();
        for (int grammarId = 0; grammarId < grammarIdToURIMap.length; ++grammarId) {
            URI uri = URI.createURI((String)grammarIdToURIMap[grammarId], (boolean)true);
            EObject grammarElement = grammarResourceSet.getEObject(uri, true);
            if (grammarElement == null) {
                throw new IllegalStateException("Apparently the grammar has changed so that it's no longer possible to identify the serialized grammar elements.  The following grammar element URI is no longer valid: " + uri.toString());
            }
            this.grammarIdToGrammarElementMap[grammarId] = grammarElement;
        }
    }

    public EObject getGrammarElement(int grammarId) {
        if (grammarId >= this.grammarIdToGrammarElementMap.length) {
            throw new IllegalStateException("Trying to obtain a grammar element that does not (or no longer) exists with id: " + grammarId);
        }
        EObject result = this.grammarIdToGrammarElementMap[grammarId];
        return result;
    }

    public int getGrammarElementMapSize() {
        return this.grammarIdToGrammarElementMap.length;
    }

    public void fillIdToEObjectMap(Resource resource) {
        SerializationUtil.fillIdToEObjectMap(resource, this.idToEObjectMap);
    }

    public EObject getSemanticObject(int id) {
        EObject eObject = this.idToEObjectMap.get(id);
        if (eObject == null) {
            throw new IllegalStateException("Trying to get an EMF object in the EMF resource that does not exist.  We are looking for id: " + id);
        }
        return eObject;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public String getCompleteContent() {
        return this.completeContent;
    }

    public GrammarElementsInterner getArrayInterner() {
        return this.arrayInterner;
    }
}

