/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;

public class JarDiscoverySource
extends AbstractCatalogSource {
    private final String id;
    private final File jarFile;

    public JarDiscoverySource(String id, File jarFile) {
        this.id = id;
        this.jarFile = jarFile;
    }

    public Object getId() {
        return this.id;
    }

    public URL getResource(String resourceName) {
        try {
            String prefix = this.jarFile.toURI().toURL().toExternalForm();
            return new URL("jar:" + prefix + "!/" + URLEncoder.encode(resourceName, StandardCharsets.UTF_8));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

