/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ocl.examples.debug.vm.messages.VMMessages;
import org.eclipse.osgi.util.NLS;

public class MiscUtil {
    private MiscUtil() {
    }

    public static IStatus makeErrorStatus(Exception e) {
        return new Status(4, "org.eclipse.ocl.examples.debug.vm", 4, NLS.bind((String)VMMessages.MiscUtil_ErrorMessage, (Object)e.getMessage()), (Throwable)e);
    }

    public static IStatus makeErrorStatus(String message, Exception e) {
        return new Status(4, "org.eclipse.ocl.examples.debug.vm", 4, message, (Throwable)e);
    }

    public static IStatus makeErrorStatus(String message) {
        return new Status(4, "org.eclipse.ocl.examples.debug.vm", 4, message, null);
    }

    public static String readAndClose(Reader reader) throws IOException {
        StringBuffer contents = new StringBuffer();
        try {
            int read;
            char[] buf = new char[4096];
            while ((read = reader.read(buf)) > 0) {
                contents.append(buf, 0, read);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return contents.toString();
    }

    public static int getLineNumber(CharSequence data, int pos) {
        int length = data.length();
        pos = Math.min(pos, length);
        int line = 1;
        int i = 0;
        while (i < pos) {
            if (data.charAt(i) == '\n') {
                ++line;
            }
            ++i;
        }
        return line;
    }
}

