/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.ResourceManagerManger;

public class FormFonts {
    private static FormFonts instance;
    private ResourceManagerManger manager = new ResourceManagerManger();
    private HashMap<Font, BoldFontDescriptor> descriptors;

    public static FormFonts getInstance() {
        if (instance == null) {
            instance = new FormFonts();
        }
        return instance;
    }

    private FormFonts() {
    }

    public Font getBoldFont(Display display, Font font) {
        this.checkHashMaps();
        BoldFontDescriptor desc = new BoldFontDescriptor(font);
        Font result = this.manager.getResourceManager(display).createFont((FontDescriptor)desc);
        this.descriptors.put(result, desc);
        return result;
    }

    public boolean markFinished(Font boldFont, Display display) {
        this.checkHashMaps();
        BoldFontDescriptor desc = this.descriptors.get(boldFont);
        if (desc != null) {
            LocalResourceManager resourceManager = this.manager.getResourceManager(display);
            resourceManager.destroyFont((FontDescriptor)desc);
            if (resourceManager.find((DeviceResourceDescriptor)desc) == null) {
                this.descriptors.remove(boldFont);
                this.validateHashMaps();
            }
            return true;
        }
        boldFont.dispose();
        return false;
    }

    private void checkHashMaps() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.descriptors.isEmpty()) {
            this.descriptors = null;
        }
    }

    private static class BoldFontDescriptor
    extends FontDescriptor {
        private FontData[] fFontData;

        BoldFontDescriptor(Font font) {
            FontData[] fontDataArray = this.fFontData = font.getFontData();
            int n = this.fFontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData element = fontDataArray[n2];
                element.setStyle(element.getStyle() | 1);
                ++n2;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof BoldFontDescriptor) {
                BoldFontDescriptor desc = (BoldFontDescriptor)((Object)obj);
                return Arrays.equals(this.fFontData, desc.fFontData);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.fFontData);
        }

        public Font createFont(Device device) throws DeviceResourceException {
            return new Font(device, this.fFontData);
        }

        public void destroyFont(Font previouslyCreatedFont) {
            previouslyCreatedFont.dispose();
        }
    }
}

