/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.resource.LUSSIDs;
import org.eclipse.ocl.pivot.resource.ASResource;

public class AS2ID {
    public static final @NonNull String DEBUG_LUSSID_COLLISIONS = "DEBUG_LUSSID_COLLISIONS";
    public static final @NonNull String DEBUG_XMIID_COLLISIONS = "DEBUG_XMIID_COLLISIONS";
    private final @NonNull Map<@NonNull Object, @Nullable Object> options;
    private final @NonNull List<@NonNull LUSSIDs> newLUSSIDs = new ArrayList<LUSSIDs>();

    public static void assignIds(@NonNull ASResource resource, @Nullable Map<@NonNull Object, @Nullable Object> options) {
        AS2ID as2id = new AS2ID(options);
        as2id.assignLUSSIDs(resource);
        as2id.assignXMIIDs();
        as2id.assignErrors();
    }

    @Deprecated
    public static void assignIds(@NonNull Iterable<Resource> resources, @Nullable Map<@NonNull Object, @Nullable Object> options) {
        AS2ID as2id = new AS2ID(options);
        for (Resource resource : Lists.newArrayList(resources)) {
            if (!(resource instanceof ASResource)) continue;
            as2id.assignLUSSIDs((ASResource)resource);
        }
        as2id.assignXMIIDs();
        as2id.assignErrors();
    }

    public static void assignIds(@NonNull List<Resource> resources, @Nullable Map<@NonNull Object, @Nullable Object> options) {
        AS2ID as2id = new AS2ID(options);
        int i = 0;
        while (i < resources.size()) {
            Resource resource = resources.get(i);
            if (resource instanceof ASResource) {
                as2id.assignLUSSIDs((ASResource)resource);
            }
            ++i;
        }
        as2id.assignXMIIDs();
        as2id.assignErrors();
    }

    private AS2ID(@Nullable Map<@NonNull Object, @Nullable Object> options) {
        this.options = options != null ? options : new HashMap();
    }

    protected void assignErrors() {
        for (LUSSIDs lussids : this.newLUSSIDs) {
            lussids.assignErrors();
        }
    }

    public int assignLUSSID(@NonNull Element element, boolean isReferenced, boolean normalizeTemplateParameters) {
        Resource resource = element.eResource();
        if (resource instanceof ASResource) {
            ASResource asResource = (ASResource)resource;
            LUSSIDs lussids = asResource.getLUSSIDs(this.options);
            return lussids.assignLUSSID(this, element, isReferenced, normalizeTemplateParameters);
        }
        String fragment = EcoreUtil.getURI((EObject)element).fragment();
        return fragment != null ? fragment.hashCode() : 0;
    }

    protected void assignLUSSIDs(@NonNull ASResource asResource) {
        LUSSIDs lussids = asResource.basicGetLUSSIDs();
        if (lussids != null && lussids.isAssignmentStarted()) {
            lussids.assignErrors();
        } else {
            lussids = asResource.getLUSSIDs(this.options);
            if (this.newLUSSIDs.contains(lussids)) {
                return;
            }
            this.newLUSSIDs.add(lussids);
            lussids.assignLUSSIDs(this);
        }
    }

    private void assignXMIIDs() {
        int i = 0;
        while (i < this.newLUSSIDs.size()) {
            LUSSIDs lussids = this.newLUSSIDs.get(i);
            lussids.assignXMIIDs(this);
            ++i;
        }
    }
}

