/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;

public abstract class TextViewerAction
extends ResourceAction
implements IUpdate {
    private ITextViewer viewer;

    protected TextViewerAction(ResourceBundle bundle, String prefix, ITextViewer viewer) {
        this(bundle, prefix);
        this.setViewer(viewer);
        this.update();
    }

    protected TextViewerAction(ResourceBundle bundle, String prefix) {
        super(bundle, prefix);
    }

    protected TextViewerAction(ResourceBundle bundle, String prefix, ITextViewer viewer, int style) {
        super(bundle, prefix, style);
        this.setViewer(viewer);
        this.update();
    }

    protected ITextViewer getTextViewer() {
        return this.viewer;
    }

    public void setViewer(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void update() {
        this.setEnabled(this.getTextViewer() != null);
    }

    protected boolean canModifyViewer() {
        ITextViewer viewer = this.getTextViewer();
        if (viewer != null) {
            return viewer.isEditable();
        }
        return false;
    }

    protected ITextSelection getSelection(ITextViewer viewer) {
        ISelectionProvider selectionProvider = viewer.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }
}

