/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMNestedEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Variable;

public class OCLVMNestedEvaluationEnvironment
extends VMNestedEvaluationEnvironment
implements OCLVMEvaluationEnvironment {
    private @NonNull Element myCurrentIP;
    private @NonNull NamedElement myOperation;
    private final int myStackDepth;
    private final long id;

    public OCLVMNestedEvaluationEnvironment(@NonNull OCLVMEvaluationEnvironment evaluationEnvironment, @NonNull NamedElement executableObject, @Nullable Object caller, long id) {
        super((VMEvaluationEnvironment)evaluationEnvironment, executableObject, caller);
        this.myStackDepth = evaluationEnvironment.getDepth() + 1;
        this.id = id;
        this.myOperation = executableObject;
        this.myCurrentIP = executableObject;
    }

    @Override
    public @NonNull OCLVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    public @NonNull Element getCurrentIP() {
        return this.myCurrentIP;
    }

    public @NonNull UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (VMEvaluationEnvironment)this, this.myCurrentIP);
    }

    public int getDepth() {
        return this.myStackDepth;
    }

    public long getID() {
        return this.id;
    }

    public @NonNull NamedElement getOperation() {
        return this.myOperation;
    }

    public @NonNull Variable getPCVariable() {
        return this.rootVMEvaluationEnvironment.getPCVariable();
    }

    @Override
    public @Nullable OCLVMEvaluationEnvironment getVMParentEvaluationEnvironment() {
        return (OCLVMEvaluationEnvironment)super.getVMParentEvaluationEnvironment();
    }

    @Override
    public @NonNull OCLVMRootEvaluationEnvironment getVMRootEvaluationEnvironment() {
        return (OCLVMRootEvaluationEnvironment)this.rootVMEvaluationEnvironment;
    }

    public boolean isDeferredExecution() {
        return this.getVMRootEvaluationEnvironment().isDeferredExecution();
    }

    public void processDeferredTasks() {
        this.getVMRootEvaluationEnvironment().processDeferredTasks();
    }

    public @NonNull Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setOperation(@NonNull NamedElement operation) {
        this.myCurrentIP = operation;
        this.myOperation = operation;
    }

    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.getVMRootEvaluationEnvironment().saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((VMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", (Throwable)e);
        }
        throw exception;
    }
}

