/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.contentprovider;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.ui.emf.utils.EcoreModelContentProvider;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.StringWithClearEditor;
import org.eclipse.papyrus.infra.widgets.providers.IFlattenableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ContextFeatureContentProvider
extends EcoreModelContentProvider
implements IStaticContentProvider,
IHierarchicContentProvider,
IFlattenableContentProvider,
IGraphicalContentProvider {
    private Table table;
    private boolean flat;
    private StructuredViewer viewer;
    private PatternViewerFilter patternFilter;
    private String currentFilterPattern;

    public ContextFeatureContentProvider(Table table, EObject root) {
        super(root);
        this.table = table;
    }

    public Object[] getElements() {
        return this.getElements(null);
    }

    public boolean isValidValue(Object element) {
        if (element == null) {
            return false;
        }
        if (!(element instanceof EObject)) {
            return false;
        }
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        RepresentationKind repKind = manager.getRepresentationKindById(this.table.getTableKindId());
        ViewPrototype prototype = ViewPrototype.get((PapyrusRepresentationKind)((PapyrusRepresentationKind)repKind));
        if (prototype == null) {
            return false;
        }
        return PolicyChecker.getFor((EObject)((EObject)element)).canHaveNewView((EObject)element, this.table.getOwner(), prototype);
    }

    public void setFlat(boolean isFlat) {
        if (isFlat != this.flat) {
            this.flat = isFlat;
            if (this.viewer != null) {
                this.viewer.refresh();
            }
        }
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer instanceof StructuredViewer ? (StructuredViewer)viewer : null;
    }

    public void createBefore(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.createPatternFilter(composite);
        this.createCaseSensitiveButton(composite);
    }

    protected void createCaseSensitiveButton(Composite parent) {
        final Button checkBoxCaseSensitive = new Button(parent, 32);
        checkBoxCaseSensitive.setText(Messages.ContextFeatureContentProvider_CaseSensitiveLabel);
        checkBoxCaseSensitive.setToolTipText(Messages.ContextFeatureContentProvider_CaseSensitiveTooltip);
        checkBoxCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ContextFeatureContentProvider.this.patternFilter instanceof PatternViewerFilter) {
                    ContextFeatureContentProvider.this.patternFilter.setIgnoreCase(!checkBoxCaseSensitive.getSelection());
                }
                ContextFeatureContentProvider.this.viewer.refresh();
            }
        });
    }

    protected void createPatternFilter(Composite parent) {
        StringWithClearEditor editor = new StringWithClearEditor(parent, 2048);
        editor.setToolTipText(Messages.ContextFeatureContentProvider_FilterTooltip);
        editor.setValidateOnDelay(Activator.getValidationDelay());
        editor.setValidateOnDelay(Activator.isFilterValidateOnDelay());
        GridLayoutFactory.fillDefaults().applyTo((Composite)editor);
        editor.setLayoutData((Object)new GridData(4, 4, true, false));
        this.patternFilter = new PatternViewerFilter();
        this.currentFilterPattern = "*";
        this.patternFilter.setPattern(this.currentFilterPattern);
        editor.addCommitListener(new ICommitListener(){

            public void commit(AbstractEditor editor) {
                String filterPattern = ((StringWithClearEditor)editor).getValue();
                ContextFeatureContentProvider.this.patternFilter.setPattern(filterPattern);
                List<ViewerFilter> filtersAsList = Arrays.asList(ContextFeatureContentProvider.this.viewer.getFilters());
                if (!filtersAsList.contains(ContextFeatureContentProvider.this.patternFilter)) {
                    ContextFeatureContentProvider.this.viewer.addFilter((ViewerFilter)ContextFeatureContentProvider.this.patternFilter);
                }
                ContextFeatureContentProvider.this.viewer.refresh();
                if (!"".equals(filterPattern) && !ContextFeatureContentProvider.this.currentFilterPattern.equals(filterPattern)) {
                    ContextFeatureContentProvider.this.currentFilterPattern = filterPattern;
                }
            }
        });
        editor.getText().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ContextFeatureContentProvider.this.viewer.getControl().setFocus();
                }
            }
        });
    }

    public void createAfter(Composite parent) {
    }
}

