/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;

public class PartialOperations {
    public static final @NonNull Function<PartialOperations, Iterable<Iterable<Operation>>> partialOperations2allOperations = new Function<PartialOperations, Iterable<Iterable<Operation>>>(){

        public Iterable<Iterable<Operation>> apply(PartialOperations partialOperations) {
            return partialOperations.getOperationsInternal(null);
        }
    };
    protected final @NonNull CompleteClassInternal completeClass;
    protected final @NonNull String name;
    private final @NonNull Map<@NonNull ParametersId, Object> map = new HashMap<ParametersId, Object>();

    public PartialOperations(@NonNull CompleteClassInternal completeClass, @NonNull String name) {
        this.completeClass = completeClass;
        this.name = name;
    }

    public void didAddOperation(@NonNull Operation pivotOperation) {
        ParametersId parametersId = pivotOperation.getParametersId();
        Object partials = this.map.get(parametersId);
        if (partials instanceof Overloads) {
            Overloads overloads = (Overloads)partials;
            overloads.add(pivotOperation);
        } else if (partials != null) {
            if (partials != pivotOperation) {
                Overloads overloads = new Overloads();
                this.map.put(parametersId, overloads);
                overloads.add((Operation)partials);
                overloads.add(pivotOperation);
            }
        } else {
            this.map.put(parametersId, pivotOperation);
        }
    }

    public boolean didRemoveOperation(@NonNull Operation pivotOperation) {
        ParametersId parametersId = pivotOperation.getParametersId();
        Object partials = this.map.get(parametersId);
        if (partials instanceof Overloads) {
            Overloads overloads = (Overloads)partials;
            overloads.remove(pivotOperation);
            if (overloads.size() == 1) {
                this.map.put(parametersId, overloads.getBest());
            } else if (overloads.size() <= 0) {
                this.map.remove(parametersId);
            }
        } else if (partials != null) {
            this.map.remove(parametersId);
        } else {
            this.map.put(parametersId, pivotOperation);
        }
        return this.map.isEmpty();
    }

    public @Nullable Operation getOperation(@NonNull ParametersId parametersId, @Nullable FeatureFilter featureFilter) {
        Object partials = this.map.get(parametersId);
        if (partials instanceof Overloads) {
            Overloads overloads = (Overloads)partials;
            Operation bestOperation = overloads.getBest();
            if (featureFilter == null) {
                return bestOperation;
            }
            for (Operation operation : overloads) {
                if (!featureFilter.accept(operation)) continue;
                return operation;
            }
            return null;
        }
        if (partials != null) {
            Operation operation = (Operation)partials;
            return featureFilter == null || featureFilter.accept(operation) ? operation : null;
        }
        return null;
    }

    public @NonNull Iterable<@NonNull Operation> getOperationOverloads(@NonNull ParametersId parametersId, final @Nullable FeatureFilter featureFilter) {
        Object partials = this.map.get(parametersId);
        if (partials instanceof Overloads) {
            Overloads overloads = (Overloads)partials;
            overloads.getBest();
            if (featureFilter == null) {
                return overloads;
            }
            return Iterables.filter((Iterable)overloads, (Predicate)new Predicate<Operation>(){

                public boolean apply(@NonNull Operation input) {
                    return featureFilter.accept(input);
                }
            });
        }
        if (partials != null) {
            Operation operation = (Operation)partials;
            if (featureFilter == null || featureFilter.accept(operation)) {
                return Collections.singletonList((Operation)partials);
            }
        }
        return Collections.emptyList();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull Operation> getOperationOverloads(final @Nullable FeatureFilter featureFilter) {
        @NonNull Iterable unfilteredOverloads = Iterables.concat((Iterable)Iterables.transform(this.map.keySet(), (Function)new Function<ParametersId, Iterable<Operation>>(){

            public @NonNull Iterable<@NonNull Operation> apply(@NonNull ParametersId parametersId) {
                return PartialOperations.this.getOperationOverloads(parametersId, featureFilter);
            }
        }));
        if (featureFilter == null) {
            return unfilteredOverloads;
        }
        return Iterables.filter((Iterable)unfilteredOverloads, (Predicate)new Predicate<Operation>(){

            public boolean apply(@NonNull Operation input) {
                return featureFilter.accept(input);
            }
        });
    }

    public @NonNull Iterable<@NonNull ? extends Operation> getOperations(final @Nullable FeatureFilter featureFilter) {
        return Iterables.transform(this.map.keySet(), (Function)new Function<ParametersId, Operation>(){

            public Operation apply(ParametersId parametersId) {
                return PartialOperations.this.getOperation(parametersId, featureFilter);
            }
        });
    }

    private @NonNull Iterable<@NonNull Iterable<@NonNull Operation>> getOperationsInternal(final @Nullable FeatureFilter featureFilter) {
        return Iterables.transform(this.map.keySet(), (Function)new Function<ParametersId, Iterable<Operation>>(){

            public @NonNull Iterable<@NonNull Operation> apply(ParametersId parametersId) {
                if (!$assertionsDisabled && parametersId == null) {
                    throw new AssertionError();
                }
                return PartialOperations.this.getOperationOverloads(parametersId, featureFilter);
            }
        });
    }

    public void initMemberOperationsPostProcess() {
        for (Object partials : this.map.values()) {
            if (!(partials instanceof Overloads)) continue;
            Overloads overloads = (Overloads)partials;
            this.initMemberOperationsPostProcess(this.completeClass.getName(), overloads);
        }
    }

    protected void initMemberOperationsPostProcess(String name, @NonNull Overloads operations) {
        operations.size();
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        for (ParametersId parametersId : this.map.keySet()) {
            s.append("\n  ");
            s.append(parametersId);
        }
        return s.toString();
    }

    private class Overloads
    implements Iterable<Operation> {
        private @Nullable OverloadsList staticOperations = null;
        private @Nullable OverloadsList nonStaticOperations = null;
        private boolean sorted = false;

        private Overloads() {
        }

        public void add(@NonNull Operation pivotOperation) {
            OverloadsList list;
            if (pivotOperation.isIsStatic()) {
                if (this.staticOperations == null) {
                    this.staticOperations = new OverloadsList();
                }
                list = this.staticOperations;
            } else {
                if (this.nonStaticOperations == null) {
                    this.nonStaticOperations = new OverloadsList();
                }
                list = this.nonStaticOperations;
            }
            assert (list != null);
            if (!list.contains(pivotOperation)) {
                list.add(pivotOperation);
                this.sorted = false;
            }
        }

        public @NonNull Operation getBest() {
            OverloadsList list;
            OverloadsList overloadsList = list = this.nonStaticOperations != null ? this.nonStaticOperations : this.staticOperations;
            assert (list != null);
            if (list.size() > 1 && !this.sorted) {
                EnvironmentFactoryInternal environmentFactory = PartialOperations.this.completeClass.getOwningCompletePackage().getCompleteModel().getEnvironmentFactory();
                if (this.nonStaticOperations != null) {
                    this.nonStaticOperations.sort(environmentFactory);
                }
                if (this.staticOperations != null) {
                    this.staticOperations.sort(environmentFactory);
                }
                this.sorted = true;
            }
            Operation bestOperation = (Operation)list.get(0);
            assert (bestOperation != null);
            return bestOperation;
        }

        @Override
        public @NonNull Iterator<@NonNull Operation> iterator() {
            OverloadsList staticOperations2 = this.staticOperations;
            OverloadsList nonStaticOperations2 = this.nonStaticOperations;
            if (staticOperations2 != null) {
                if (nonStaticOperations2 != null) {
                    return Iterators.concat(nonStaticOperations2.iterator(), staticOperations2.iterator());
                }
                return staticOperations2.iterator();
            }
            if (nonStaticOperations2 != null) {
                return nonStaticOperations2.iterator();
            }
            return ClassUtil.emptyIterator();
        }

        public boolean remove(@NonNull Operation pivotOperation) {
            if (pivotOperation.isIsStatic()) {
                OverloadsList staticOperations2 = this.staticOperations;
                if (staticOperations2 != null) {
                    boolean remove = staticOperations2.remove(pivotOperation);
                    if (staticOperations2.isEmpty()) {
                        this.staticOperations = null;
                    }
                    return remove;
                }
            } else {
                OverloadsList nonStaticOperations2 = this.nonStaticOperations;
                if (nonStaticOperations2 != null) {
                    boolean remove = nonStaticOperations2.remove(pivotOperation);
                    if (nonStaticOperations2.isEmpty()) {
                        this.nonStaticOperations = null;
                    }
                    return remove;
                }
            }
            return false;
        }

        public int size() {
            OverloadsList staticOperations2 = this.staticOperations;
            OverloadsList nonStaticOperations2 = this.nonStaticOperations;
            return (staticOperations2 != null ? staticOperations2.size() : 0) + (nonStaticOperations2 != null ? nonStaticOperations2.size() : 0);
        }
    }

    private static class OverloadsList
    extends ArrayList<Operation>
    implements Comparator<Integer> {
        private static final long serialVersionUID = 1L;
        private Integer[] keys;
        private Integer[] metrics;

        public OverloadsList() {
            super(4);
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            Integer m1 = this.metrics[o1];
            Integer m2 = this.metrics[o2];
            return m2 - m1;
        }

        public void sort(@NonNull EnvironmentFactory environmentFactory) {
            StandardLibrary standardLibrary = environmentFactory.getStandardLibrary();
            int size = this.size();
            @NonNull Integer @NonNull [] keys2 = new Integer[size];
            this.keys = keys2;
            this.metrics = new Integer[size];
            @NonNull Integer index = 0;
            for (Operation operation : this) {
                int depth;
                keys2[index.intValue()] = index;
                int metric = 0;
                Class owningClass = operation.getOwningClass();
                CompleteInheritance inheritance = owningClass.getInheritance(standardLibrary);
                metric = depth = inheritance.getDepth();
                this.metrics[index.intValue()] = metric;
                index = index + 1;
            }
            Arrays.sort(this.keys, this);
            ArrayList<@NonNull Operation> savedOperations = new ArrayList<Operation>(this);
            this.clear();
            int i = 0;
            while (i < size) {
                this.add((Operation)savedOperations.get(this.keys[i]));
                ++i;
            }
            this.keys = null;
            this.metrics = null;
        }
    }
}

