/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.extender;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;

public class DifferenceGroupExtenderRegistryImpl
implements IDifferenceGroupExtender.Registry {
    private final Map<String, IDifferenceGroupExtender> map = new ConcurrentHashMap<String, IDifferenceGroupExtender>();

    public List<IDifferenceGroupExtender> getExtenders() {
        Collection<IDifferenceGroupExtender> extenders = this.map.values();
        ArrayList ret = Lists.newArrayList();
        for (IDifferenceGroupExtender groupExtender : extenders) {
            ret.add(groupExtender);
        }
        return ret;
    }

    @Override
    public IDifferenceGroupExtender add(IDifferenceGroupExtender provider) {
        Preconditions.checkNotNull((Object)provider);
        return this.map.put(provider.getClass().getName(), provider);
    }

    @Override
    public IDifferenceGroupExtender remove(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

