/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OSGiActivator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIActivator
extends AbstractUIPlugin {
    private OMBundle omBundle;
    protected BundleContext bundleContext;

    public UIActivator(OMBundle omBundle) {
        this.omBundle = omBundle;
    }

    public final OMBundle getOMBundle() {
        return this.omBundle;
    }

    public ImageDescriptor loadImageDescriptor(String path) {
        return UIActivator.imageDescriptorFromPlugin((String)this.omBundle.getBundleID(), (String)path);
    }

    public IDialogSettings getDialogSettings(Class<?> clazz) {
        return this.getDialogSettings(clazz.getName());
    }

    public IDialogSettings getDialogSettings(String section) {
        return DialogSettings.getOrCreateSection((IDialogSettings)this.getDialogSettings(), (String)section);
    }

    public final void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        OSGiActivator.traceStart((BundleContext)context);
        if (this.omBundle == null) {
            throw new IllegalStateException("bundle == null");
        }
        try {
            super.start(context);
            this.setBundleContext(context);
            ((AbstractBundle)this.omBundle).start();
            this.doStart();
        }
        catch (Error error) {
            this.omBundle.logger().error((Throwable)error);
            throw error;
        }
        catch (Exception ex) {
            this.omBundle.logger().error((Throwable)ex);
            throw ex;
        }
    }

    public final void stop(BundleContext context) throws Exception {
        OSGiActivator.traceStop((BundleContext)context);
        if (this.omBundle == null) {
            throw new IllegalStateException("bundle == null");
        }
        try {
            this.doStop();
            ((AbstractBundle)this.omBundle).stop();
            this.setBundleContext(null);
            super.stop(context);
        }
        catch (Error error) {
            this.omBundle.logger().error((Throwable)error);
            throw error;
        }
        catch (Exception ex) {
            this.omBundle.logger().error((Throwable)ex);
            throw ex;
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    private void setBundleContext(BundleContext context) {
        this.omBundle.setBundleContext((Object)context);
    }

    public static abstract class WithState
    extends UIActivator {
        private OSGiActivator.StateHandler handler = new OSGiActivator.StateHandler(this.getOMBundle()){

            protected void startWithState(Object state) throws Exception {
                this.doStartWithState(state);
            }

            protected Object stopWithState() throws Exception {
                return this.doStopWithState();
            }
        };

        public WithState(OMBundle bundle) {
            super(bundle);
        }

        @Override
        protected final void doStart() throws Exception {
            this.handler.start();
        }

        @Override
        protected final void doStop() throws Exception {
            this.handler.stop();
        }

        protected abstract void doStartWithState(Object var1) throws Exception;

        protected abstract Object doStopWithState() throws Exception;
    }
}

